package eu.dnetlib.api.functionality;

import java.util.List;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.functionality.Rating;

/**
 * This interface describes the methods available for a rating service.
 * @author thanos@di.uoa.gr
 *
 */
public interface RatingService extends DriverService {
	/**
	 * Rate a document by a specifed user.
	 * @param userId the id of the user
	 * @param documentId the id of the document
	 * @param score the rating score
	 * @throws RatingServiceException if any errors occur
	 */
	public void rate(String userId, String documentId, float score) throws RatingServiceException;
	
	/**
	 * Search for existing ratings by user.
	 * @param userId the id of the user
	 * @return a list containing all the ratings of the specified user ordered by score
	 * @throws RatingServiceException if any errors occur
	 */
	public List<Rating> searchRatingsByUser(String userId) throws RatingServiceException;
	
	/**
	 * Search for existing ratings by document.
	 * @param documentId the id of the document
	 * @return a list containing all the ratings of the soecified document ordered by score
	 * @throws RatingServiceException if any errors occur
	 */
	public List<Rating> searchRatingsByDocument(String documentId) throws RatingServiceException;
	
	/**
	 * Get the top ratings.
	 * @param limit the maximum number of ratings to retrieve
	 * @return a list containing the top ratings ordered by score
	 * @throws RatingServiceException if any errors occur
	 */
	public List<Rating> getTopRatings(int limit) throws RatingServiceException;
	
	/**
	 * Get the top documents.
	 * @param limit the maximum number of ratings to retrieve
	 * @return a list containing the top document average ratings ordered by score
	 * @throws RatingServiceException if any errors occur
	 */
	public List<Rating> getTopDocuments(int limit) throws RatingServiceException;
}
