package eu.dnetlib.api.functionality;

import java.util.List;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.domain.functionality.UserProfileSearchCriteria;

/**
 * Class that manages UserProfile objects.
 */
public interface UserProfileService extends DriverService {

	public UserProfile saveUser(UserProfile profile)
			throws UserProfileServiceException;

	public void deleteUser(UserProfile profile)
			throws UserProfileServiceException;

	public void deleteUserById(String id) throws UserProfileServiceException;

	public UserProfile getUserById(String id)
			throws UserProfileServiceException;

	public List<UserProfile> searchUsers(UserProfileSearchCriteria criteria)
			throws UserProfileServiceException;

	public List<String> searchUserIds(UserProfileSearchCriteria criteria)
			throws UserProfileServiceException;
}