package eu.dnetlib.api.enabling;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.EPR;

import java.util.List;

public interface DatabaseService extends DriverService {

	public boolean importFromEPR(String db, EPR epr, String xslt);

	public boolean importFromList(String db, List<String> records, String xslt);

    public EPR searchSQL(String db, String sql);

    public EPR searchSQL(String db, String sql, String sqlForSize);

    public EPR xsltSearchSQL(String db, String sql, String xslt);

    public EPR xsltSearchSQL(String db, String sql, String sqlForSize, String xslt);

    public boolean updateSQL(String db, String sql);
}
