package eu.dnetlib.api.enabling;

import java.util.List;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.EPR;

public interface ResultSetService extends DriverService {

	EPR createPullRSEPR(EPR dataProviderEPR, String bdId, int initialPageSize,
			int expiryTime, String styleSheet, Integer keepAliveTime,
			Integer total);

	EPR createPullRS(String dataProviderServiceAddress, String bdId,
			int initialPageSize, int expiryTime, String styleSheet,
			Integer keepAliveTime, Integer total);

	void closeRS(String rsId);

	List<String> getResult(String rsId, int fromPosition, int toPosition,
			String requestMode) throws ResultSetServiceException;

	int getNumberOfElements(String rsId) throws ResultSetServiceException;

	EPR createPushRS(int expiryTime, int keepAliveTime)
			throws ResultSetServiceException;

	String populateRS(String rsId, List<String> elements)
			throws ResultSetServiceException;

	String getRSStatus(String rsId) throws ResultSetServiceException;

	String getProperty(String rsId, String name)
			throws ResultSetServiceException;
}
