package eu.dnetlib.api.functionality;

/**
 * This exception is thrown by alert service if any errors occur.
 * @author thanos@di.uoa.gr
 * @see AlertService
 *
 */
public class AlertServiceException extends Exception {
	private static final long serialVersionUID = 1L;

	/**
	 * Construct a new alert service exception with the specified message and cause.
	 * @param message the message
	 * @param cause the cause
	 */
	public AlertServiceException(final String message, final Throwable cause) {
		super(message, cause);
	}
	
	/**
	 * Construct a new alert service exception with the specified message.
	 * @param message the message
	 */
	public AlertServiceException(final String message) {
		super(message);
	}
}
