package eu.dnetlib.api.functionality;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.functionality.ConversionStatus;

public interface ConversionService extends DriverService { 
	
	/**
	 * Adds a conversion job
	 * @param fileUrl the url of the file to be converted
	 * @param format the desired format 
	 * @return the {@link ConversionStatus} of the conversion job
	 * @throws ConversionServiceException
	 */
	public ConversionStatus addJob(String fileUrl, String format)  
				throws ConversionServiceException;
	/**
	 * The {@link ConversionStatus} of a conversion job 
	 * @param conversionId the id of the conversion job
	 * @return the {@link ConversionStatus}  
	 * @throws ConversionServiceException
	 */
	public ConversionStatus getStatus(String conversionId) 
				throws ConversionServiceException;
	
}
