package eu.dnetlib.api.enabling;

import java.util.List;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.EPR;

public interface ISSNService extends DriverService {
	String getCurrentMessage(String topic) throws ISSNServiceException;

	boolean pauseSubscription(String subscrId) throws ISSNServiceException;

	boolean renew(String subscrId, int terminationTime) throws ISSNServiceException;

	boolean resumeSubscription(String subscrId) throws ISSNServiceException;

	String subscribe(
			EPR consumerReference,
			String topicExpression,
			int initialTerminationTime) throws ISSNServiceException;

	boolean unsubscribe(String subscrId) throws ISSNServiceException;

	boolean actionCreatePerformed(
			String resourceType,
			String profileId,
			String profile) throws ISSNServiceException;

	boolean actionUpdatePerformed(
			String resourceType,
			String profileId,
			String profileBefore,
			String profileAfter) throws ISSNServiceException;

	boolean actionDeletePerformed(String resourceType, String profileId)
			throws ISSNServiceException;

	List<String> listSubscriptions();
}
