package eu.dnetlib.api.functionality;

import java.util.List;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.functionality.Collection;
import eu.dnetlib.domain.functionality.CollectionSearchCriteria;

public interface CollectionService extends DriverService {

	public Collection getCollection(String collectionId)
			throws CollectionServiceException;

	public List<Collection> getCollections(List<String> collectionIds)
			throws CollectionServiceException;

	public void updateCollection(Collection collection)
			throws CollectionServiceException;
			
	public void deleteCollection(String collectionId)
			throws CollectionServiceException;

	public String createCollection(Collection collection)
			throws CollectionServiceException;
	
	public List<Collection> searchCollections(CollectionSearchCriteria criteria) 
			throws CollectionServiceException;
}