package eu.dnetlib.api.functionality;

import eu.dnetlib.api.DriverServiceException;

/**
 * This exception is thrown by forum service on any error.
 * @author thanos@di.uoa.gr
 *
 */
public class ForumServiceException extends DriverServiceException {
	/**
	 * Used for serialization / deserialization
	 */
	private static final long serialVersionUID = -8624823395470214377L;

	/**
	 * Create a new forum service exception.
	 */
	public ForumServiceException() {
		super();
	}
	
	/**
	 * Create a new forum service exception with the specified error message.
	 * @param message the error message
	 */
	public ForumServiceException(String message) {
		super(message);
	}
	
	/**
	 * Create a new forum service exception with the specified cause.
	 * @param cause the cause
	 */
	public ForumServiceException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Create a new forum service exception with the specified error message and cause.
	 * @param message the error message
	 * @param cause the cause
	 */
	public ForumServiceException(String message, Throwable cause) {
		super(message, cause);
	}
}
