/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package eu.espas.cql.trans.relation;

import eu.espas.cql.trans.ComplexRelationTransformIF;
import eu.espas.cql.trans.CQLProcessingException;
import org.z3950.zing.cql.CQLRelation;

/**
 *
 * @author gathanas
 */
public class DateWithinTransformer implements ComplexRelationTransformIF {

    public String getSupportedRelationCQL() {
        return "within/date";
    }

    public String getSupportedRelationSQL() {
        return "";
    }

    public String transformClause(String index, CQLRelation relation, String term) throws CQLProcessingException{
        String outcome =" ";

        if(term.matches("[(\\[][^\\s]*[,\\s][^\\s]*[)\\]]")){
            String[] subTermArray = term.split("[,\\s]", 2);
            
            if(subTermArray[0].startsWith("("))
                outcome+= index+">'"+subTermArray[0].replace("(", "")+"'";
            else 
                outcome+= index+">='"+subTermArray[0].replace("[", "")+"'";

            if(subTermArray.length>1){
                if(subTermArray[1].endsWith(")"))
                    outcome+= " AND "+index+"<'"+subTermArray[1].replace(")", "")+"'";
                else 
                    outcome+= " AND "+index+"<='"+subTermArray[1].replace("]", "")+"'";
            }
            }

        else if(term.matches("[^\\s]*[,\\s][^\\s]*")){
            outcome= "";
            String[] subTermArray = term.split("[,\\s]", 2);
            outcome+= index+">'"+subTermArray[0]+"'";

            if(subTermArray.length>1)
                outcome+= " AND "+index+"<'"+subTermArray[1]+"'";
            
        }
        
        else 
            throw new CQLProcessingException("Unsupported syntax of term :"+term);
        
        return "("+outcome+")";
    }
    
}
