/*
 * Decompiled with CFR 0.152.
 */
package eu.espas.cql.trans;

import eu.espas.cql.trans.CQLProcessingException;
import eu.espas.cql.trans.ComplexRelationTransformIF;
import eu.espas.cql.trans.ESPASTermMetaMap;
import eu.espas.cql.trans.TermMetaMap;
import eu.espas.cql.trans.TransformationVisitor;
import eu.espas.cql.trans.relation.DateWithinTransformer;
import java.util.HashSet;
import java.util.Set;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;

public class ESPASTransformationVisitor
extends TransformationVisitor {
    private Set<String> visitedTables = new HashSet<String>();

    public ESPASTransformationVisitor() {
        this.init();
    }

    @Override
    public String visitTerm(CQLTermNode termNode) throws CQLProcessingException {
        String cqlIndex = termNode.getIndex();
        String cqlTerm = termNode.getTerm();
        String output = "";
        if (!this.isSupportedCQLIndex(cqlIndex)) {
            throw new CQLProcessingException("Unsupported term :" + cqlIndex + " was used in expression :" + termNode.toCQL());
        }
        if (this.indexTermMappings.containsKey(cqlIndex)) {
            if (this.indexTermMappings.get(cqlIndex) instanceof ESPASTermMetaMap) {
                this.visitedTables.add(((ESPASTermMetaMap)this.indexTermMappings.get(cqlIndex)).getDbTableName());
            }
            cqlIndex = ((TermMetaMap)this.indexTermMappings.get(cqlIndex)).getTermMappedName();
        }
        for (String replTermCont : this.termMappings.keySet()) {
            if (!cqlTerm.contains(replTermCont)) continue;
            if (this.termMappings.get(cqlTerm) instanceof ESPASTermMetaMap) {
                this.visitedTables.add(((ESPASTermMetaMap)this.termMappings.get(cqlIndex)).getDbTableName());
            }
            cqlTerm = cqlTerm.replaceAll(replTermCont, ((TermMetaMap)this.termMappings.get(replTermCont)).getTermMappedName());
        }
        cqlTerm = cqlTerm.equals(termNode.getTerm()) ? "'" + cqlTerm + "'" : cqlTerm;
        output = this.processClause(cqlIndex, termNode.getRelation(), cqlTerm);
        return output;
    }

    private String processClause(String index, CQLRelation relNode, String term) throws CQLProcessingException {
        String output = "";
        output = this.relationMappings.containsKey(relNode.toCQL()) ? ((ComplexRelationTransformIF)this.relationMappings.get(relNode.toCQL())).transformClause(index, relNode, term) : index + " " + this.visitClause(relNode) + " " + term;
        return output;
    }

    @Override
    public String visitClause(CQLRelation clauseNode) throws CQLProcessingException {
        String outcome = clauseNode.toCQL();
        if (this.relationMappings.containsKey(outcome)) {
            outcome = ((ComplexRelationTransformIF)this.relationMappings.get(outcome)).getSupportedRelationSQL();
        }
        return outcome;
    }

    @Override
    public String visitQuery(CQLBooleanNode queryNode) throws CQLProcessingException {
        String outcome = "(" + super.visitExpression(queryNode.getLeftOperand());
        if (queryNode instanceof CQLAndNode) {
            outcome = outcome + " AND ";
        } else if (queryNode instanceof CQLOrNode) {
            outcome = outcome + " OR ";
        } else if (queryNode instanceof CQLNotNode) {
            outcome = outcome + " NOT ";
        }
        outcome = outcome + super.visitExpression(queryNode.getRightOperand()) + ")";
        return outcome;
    }

    @Override
    public String prepareConstraintExpression(String contraint) throws CQLProcessingException {
        return " where " + contraint;
    }

    @Override
    public String prepareQueryExpression(String contraint) throws CQLProcessingException {
        String fromPart = " from \"shadow\".observation";
        String whereClause = contraint;
        String projectionPart = "select \"shadow\".observation.id ";
        for (String tableName : this.visitedTables) {
            if (tableName.equalsIgnoreCase("\"shadow\".observation") || tableName.isEmpty()) continue;
            fromPart = fromPart + " join " + tableName + " on observation.id=" + tableName + ".observation";
        }
        for (String extraProjection : this.projectionTerms) {
            projectionPart = projectionPart + ", " + extraProjection;
        }
        return projectionPart + fromPart + whereClause;
    }

    private void init() {
        this.indexTermMappings.put("dc.ServerSelection", new ESPASTermMetaMap("dc.ServerSelection", "", ""));
        this.indexTermMappings.put("process", new ESPASTermMetaMap("process", "\"shadow\".observation_procedure.procedure", "\"shadow\".observation_procedure"));
        this.indexTermMappings.put("project", new ESPASTermMetaMap("project", "\"shadow\".observation_project.project", "\"shadow\".observation_project"));
        this.indexTermMappings.put("computation", new ESPASTermMetaMap("computation", "\"shadow\".observation_computation.computation", "\"shadow\".observation_computation"));
        this.indexTermMappings.put("instrument", new ESPASTermMetaMap("instrument", "\"shadow\".observation_instrument.instrument", "\"shadow\".observation_instrument"));
        this.indexTermMappings.put("platform", new ESPASTermMetaMap("platform", "\"shadow\".observation_platform.platform", "\"shadow\".observation_platform"));
        this.indexTermMappings.put("phenomenonTime", new ESPASTermMetaMap("phenomenonTime", "\"shadow\".observation.startdate", "\"shadow\".observation"));
        this.indexTermMappings.put("startPhenomenonTime", new ESPASTermMetaMap("phenomenonTime", "\"shadow\".observation.startdate", "\"shadow\".observation"));
        this.indexTermMappings.put("endPhenomenonTime", new ESPASTermMetaMap("phenomenonTime", "\"shadow\".observation.enddate", "\"shadow\".observation"));
        this.indexTermMappings.put("location", new ESPASTermMetaMap("location", "\"shadow\".observation_location.location", "\"shadow\".observation_location"));
        this.indexTermMappings.put("observedProperty", new ESPASTermMetaMap("observedProperty", "\"shadow\".observation_observedproperty.observedproperty", "\"shadow\".observation_observedproperty"));
        this.termMappings.put("now", new TermMetaMap("now", "now()"));
        DateWithinTransformer dTransformer = new DateWithinTransformer();
        this.relationMappings.put(dTransformer.getSupportedRelationCQL(), dTransformer);
    }

    @Override
    void clearVisitor() {
        this.visitedTables = new HashSet<String>();
    }
}

