/*
 * Decompiled with CFR 0.152.
 */
package eu.espas.cql.trans;

import eu.espas.cql.trans.CQLProcessingException;
import eu.espas.cql.trans.TransformationVisitor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;

public class TransformationEngine {
    private static final Logger _logger = Logger.getLogger(TransformationEngine.class);
    private CQLParser cqlParser;
    private TransformationVisitor visitor;

    public TransformationEngine(TransformationVisitor visitor) {
        this.visitor = visitor;
        this.cqlParser = new CQLParser();
    }

    public String getQueryClause(String cqlExpression) throws CQLProcessingException {
        this.visitor.clearVisitor();
        String result = this.visitor.prepareQueryExpression(this.getConstraintClause(cqlExpression));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConstraintClause(String cqlExpression) {
        this.visitor.clearVisitor();
        String result = "";
        StringReader reader = new StringReader(cqlExpression);
        try {
            CQLNode expressionRoot = this.parseExpression(reader);
            result = this.visitor.visitExpression(expressionRoot);
            result = this.visitor.prepareConstraintExpression(result);
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception while parsing CQL expression :" + cqlExpression), (Throwable)ex);
        }
        finally {
            return result;
        }
    }

    private CQLNode parseExpression(Reader expressionReader) throws CQLParseException, IOException {
        CQLNode result = this.cqlParser.parse(expressionReader);
        return result;
    }
}

