/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package eu.espas.cql.trans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;

/**
 *
 * @author gathanas
 */
public abstract class TransformationVisitor {
    protected Set<String> supportedCQLIndexTerms = new HashSet<String>();
//  additional terms expected to be returned by the query
    protected Set<String> projectionTerms = new HashSet<String>();
//    holds mappings from index term names specified in CQL to the ones expected by the visitor
    protected Map<String, TermMetaMap> indexTermMappings=new HashMap<String, TermMetaMap>();
//    holds mappings from term names specified in CQL to the ones expected by the visitor
    protected Map<String, TermMetaMap> termMappings = new HashMap<String, TermMetaMap>();
//    holds mappings from relations names specified in CQL to the ones expected by the visitor
    protected Map<String, ComplexRelationTransformIF> relationMappings = new HashMap<String, ComplexRelationTransformIF>();

    /**Default constructor
     */
    public TransformationVisitor() {
    }
    
    protected boolean isSupportedCQLIndex(String term){
        if (supportedCQLIndexTerms.isEmpty())
            return true;
        else
            return supportedCQLIndexTerms.contains(term);
    }

    /**This list will specify the additional terms to be included in the query projection part.
     */
    public void setProjectionTerms(Set<String> projectionTerms) {
        this.projectionTerms = projectionTerms;
    }
    
    
/** This operation is the starting point for handling the transformation of the provided CQL Expression into the expected format.
 * The provided implementation operates in breadth first mode and combines the outcomes of the expression tree nodes recursively.
 * It is imperative that the visitQuery and visitClause implementations recursively call the visitExpressionNode operation.
 */    
    public String visitExpression(CQLNode rootExpressionNode)throws CQLProcessingException{
        String result ="";
        if(rootExpressionNode instanceof CQLTermNode)
            result = visitTerm((CQLTermNode) rootExpressionNode);
        else if (rootExpressionNode instanceof CQLRelation)
            result= visitClause((CQLRelation) rootExpressionNode);
        else if (rootExpressionNode instanceof CQLBooleanNode)
            result = visitQuery((CQLBooleanNode) rootExpressionNode);
        
        return result;
    }
    
    public abstract String visitTerm(CQLTermNode termNode) throws CQLProcessingException;

    public abstract String visitClause(CQLRelation clauseNode)throws CQLProcessingException;
    
    public abstract String visitQuery(CQLBooleanNode queryNode)throws CQLProcessingException;
    
//   ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    this set of operations accommodate the formulation of the query that will be returned back to the requestor/TransformationEngine
    public abstract String prepareConstraintExpression(String contraint)throws CQLProcessingException;

    public abstract String prepareQueryExpression(String contraint)throws CQLProcessingException;
    
    void clearVisitor(){
    }
}
