/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.espas.cql.trans;

import eu.espas.cql.trans.relation.DateWithinTransformer;
import java.util.HashSet;
import java.util.Set;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;

/**
 * The ESPASTransformationVisitor is an implementation of a visitor that is used for transforming CQL descriptions embedded in ObservationCollection
 * queries into SQL queries that will be executed on the ESPAS db.
 *
 * @author gathanas
 */
public class ESPASTransformationVisitor extends TransformationVisitor {

   private Set<String> visitedTables = new HashSet<String>();

   public ESPASTransformationVisitor() {
      super();
      init();
   }

   @Override
   public String visitTerm(CQLTermNode termNode) throws CQLProcessingException {
      String cqlIndex = termNode.getIndex();
      String cqlTerm = termNode.getTerm();

      String output = "";
//        replace index term according to mapping
      if (!isSupportedCQLIndex(cqlIndex)) {
         throw new CQLProcessingException("Unsupported term :" + cqlIndex + " was used in expression :" + termNode.toCQL());
      }

//        use specifed index term mappings to change specified CQL indexes
      if (this.indexTermMappings.containsKey(cqlIndex)) {
         if (indexTermMappings.get(cqlIndex) instanceof ESPASTermMetaMap) {
            visitedTables.add(((ESPASTermMetaMap) indexTermMappings.get(cqlIndex)).getDbTableName());
         }
         cqlIndex = indexTermMappings.get(cqlIndex).getTermMappedName();
      }

//        find inside terms possible replacements 
      for (String replTermCont : this.termMappings.keySet()) {
         if (cqlTerm.contains(replTermCont)) {
            if (termMappings.get(cqlTerm) instanceof ESPASTermMetaMap) {
               visitedTables.add(((ESPASTermMetaMap) termMappings.get(cqlIndex)).getDbTableName());
            }
            cqlTerm = cqlTerm.replaceAll(replTermCont, this.termMappings.get(replTermCont).getTermMappedName());
         }
      }

//      if this is not a term that is changed in someway then add it in '' to be on the safe side  
      cqlTerm = cqlTerm.equals(termNode.getTerm()) ? "'" + cqlTerm + "'" : cqlTerm;

      output = processClause(cqlIndex, termNode.getRelation(), cqlTerm);

      return output;
   }

   private String processClause(String index, CQLRelation relNode, String term) throws CQLProcessingException {
      String output = "";

      if (this.relationMappings.containsKey(relNode.toCQL())) {
         output = relationMappings.get(relNode.toCQL()).transformClause(index, relNode, term);
      } else {
         output = index + " " + visitClause(relNode) + " " + term;
      }

      return output;
   }

   @Override
   public String visitClause(CQLRelation clauseNode) throws CQLProcessingException {
//        don't know if this is needed; will have to test it
      String outcome = clauseNode.toCQL();

      if (this.relationMappings.containsKey(outcome)) {
         outcome = relationMappings.get(outcome).getSupportedRelationSQL();
      }

      return outcome;
   }

   @Override
   public String visitQuery(CQLBooleanNode queryNode) throws CQLProcessingException {

      String outcome = "(" + super.visitExpression(queryNode.getLeftOperand());

      if (queryNode instanceof CQLAndNode) {
         outcome += " AND ";
      } else if (queryNode instanceof CQLOrNode) {
         outcome += " OR ";
      } else if (queryNode instanceof CQLNotNode) {
         outcome += " NOT ";
      }

      outcome += super.visitExpression(queryNode.getRightOperand()) + ")";

      return outcome;
   }

   @Override
   public String prepareConstraintExpression(String contraint) throws CQLProcessingException {
      String expression="";
      if(contraint!=null && !contraint.isEmpty())
         expression = " where " + contraint;
      return expression;
   }

   @Override
   public String prepareQueryExpression(String contraint) throws CQLProcessingException {
      String fromPart = " from \"shadow\".observation";
      String whereClause = contraint;
      String projectionPart = "select \"shadow\".observation.id ";

      for (String tableName : this.visitedTables) {
         if (!tableName.equalsIgnoreCase("\"shadow\".observation") && !tableName.isEmpty()) {
            fromPart += " join " + tableName + " on observation.id=" + tableName + ".observation";
         }
      }

//        might need some extra check to ensure that the additional projection parts are in the from list
      for (String extraProjection : this.projectionTerms) {
         projectionPart += ", " + extraProjection;
      }

      return projectionPart + fromPart + whereClause;
   }

/////////////////////////////////////////////////////////////////////////////////////////////
   //          Private methods used for supporting the provided functionality
   /**
    * Initializes the mappings table used in the context of ESPAS
    */
   private void init() {
//        include indexTerm mappings
      this.indexTermMappings.put("dc.ServerSelection", new ESPASTermMetaMap("dc.ServerSelection", "", ""));
      this.indexTermMappings.put("process", new ESPASTermMetaMap("process", "\"shadow\".observation_procedure.procedure", "\"shadow\".observation_procedure"));
      this.indexTermMappings.put("project", new ESPASTermMetaMap("project", "\"shadow\".observation_project.project", "\"shadow\".observation_project"));
      this.indexTermMappings.put("computation", new ESPASTermMetaMap("computation", "\"shadow\".observation_computation.computation", "\"shadow\".observation_computation"));
      this.indexTermMappings.put("instrument", new ESPASTermMetaMap("instrument", "\"shadow\".observation_instrument.instrument", "\"shadow\".observation_instrument"));
      this.indexTermMappings.put("platform", new ESPASTermMetaMap("platform", "\"shadow\".observation_platform.platform", "\"shadow\".observation_platform"));
      this.indexTermMappings.put("phenomenonTime", new ESPASTermMetaMap("phenomenonTime", "\"shadow\".observation.startdate", "\"shadow\".observation"));
      this.indexTermMappings.put("startPhenomenonTime", new ESPASTermMetaMap("phenomenonTime", "\"shadow\".observation.startdate", "\"shadow\".observation"));
      this.indexTermMappings.put("endPhenomenonTime", new ESPASTermMetaMap("phenomenonTime", "\"shadow\".observation.enddate", "\"shadow\".observation"));
      this.indexTermMappings.put("location", new ESPASTermMetaMap("location", "\"shadow\".observation_location.location", "\"shadow\".observation_location"));
      this.indexTermMappings.put("observedProperty", new ESPASTermMetaMap("observedProperty", "\"shadow\".observation_observedproperty.observedproperty", "\"shadow\".observation_observedproperty"));
//        include term mappings
      this.termMappings.put("now", new TermMetaMap("now", "now()"));

//        include relationMappigns
      DateWithinTransformer dTransformer = new DateWithinTransformer();
      this.relationMappings.put(dTransformer.getSupportedRelationCQL(), dTransformer);
   }

   @Override
   void clearVisitor() {
      visitedTables = new HashSet<String>();
   }

}
