/*
 * Decompiled with CFR 0.152.
 */
package eu.espas.cql.trans;

import eu.espas.cql.trans.CQLProcessingException;
import eu.espas.cql.trans.ComplexRelationTransformIF;
import eu.espas.cql.trans.TermMetaMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;

public abstract class TransformationVisitor {
    protected Set<String> supportedCQLIndexTerms = new HashSet<String>();
    protected Set<String> projectionTerms = new HashSet<String>();
    protected Map<String, TermMetaMap> indexTermMappings = new HashMap<String, TermMetaMap>();
    protected Map<String, TermMetaMap> termMappings = new HashMap<String, TermMetaMap>();
    protected Map<String, ComplexRelationTransformIF> relationMappings = new HashMap<String, ComplexRelationTransformIF>();

    protected boolean isSupportedCQLIndex(String term) {
        if (this.supportedCQLIndexTerms.isEmpty()) {
            return true;
        }
        return this.supportedCQLIndexTerms.contains(term);
    }

    public void setProjectionTerms(Set<String> projectionTerms) {
        this.projectionTerms = projectionTerms;
    }

    public String visitExpression(CQLNode rootExpressionNode) throws CQLProcessingException {
        String result = "";
        if (rootExpressionNode instanceof CQLTermNode) {
            result = this.visitTerm((CQLTermNode)rootExpressionNode);
        } else if (rootExpressionNode instanceof CQLRelation) {
            result = this.visitClause((CQLRelation)rootExpressionNode);
        } else if (rootExpressionNode instanceof CQLBooleanNode) {
            result = this.visitQuery((CQLBooleanNode)rootExpressionNode);
        }
        return result;
    }

    public abstract String visitTerm(CQLTermNode var1) throws CQLProcessingException;

    public abstract String visitClause(CQLRelation var1) throws CQLProcessingException;

    public abstract String visitQuery(CQLBooleanNode var1) throws CQLProcessingException;

    public abstract String prepareConstraintExpression(String var1) throws CQLProcessingException;

    public abstract String prepareQueryExpression(String var1) throws CQLProcessingException;

    void clearVisitor() {
    }
}

