package eu.dnetlib.espas.data.harvest.csw;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.espas.data.harvest.csw.common.CSWConstants;
import eu.dnetlib.espas.data.harvest.csw.common.CSWKVPEncodingStrs;
import eu.dnetlib.espas.data.harvest.csw.common.CSWOutputFormatEnum;
import eu.dnetlib.espas.data.harvest.csw.common.CSWOutputFormatStrs;
import eu.dnetlib.espas.data.harvest.csw.common.Version;


/**
 * Abstract base class for the requests of all operations.
 */
public abstract class AbstractCSWRequest
{
   {  // Class initialization.
      logger = Logger.getLogger(AbstractCSWRequest.class);
   }
   private static Logger logger = null;
   private String baseURL = null;
   private String service = null;
   private Version version = null;
   private CSWOutputFormatEnum outputFormat;

   /*
   * @param version protocol version (default : 2.0.2)
   * @param outputFormat controls the format of the output regarding to a MIME-type (default: application/xml)
   */
   public AbstractCSWRequest()
   {
      this.baseURL = null;
      this.service = CSWConstants.CSW_Service_NAME_STR;
      this.version = CSWConstants.VERSION_202;
      this.outputFormat = CSWOutputFormatEnum.CSW_OUTPUT_FORMAT_APPLICATION_XML;
   }

   public AbstractCSWRequest(String baseURL, String service, Version version, CSWOutputFormatEnum outputFormat )
   {
      this.setBaseURL(baseURL);
      this.version = version;
      this.outputFormat = outputFormat;
   }

   private String getGETMethodURLPartForAbstractCSWRequest()
   {
	  String _toString = null;
      Formatter formatter = new Formatter();
      Map<String, String> getParameters = new LinkedHashMap<String, String>();

      // Specify the csw service
      if(null == this.getService() || this.getService().toString().equals(""))
      {
         getParameters.put(CSWKVPEncodingStrs.CSW_GET_RECORDS_KVP_KEY_SERVICE_STR, CSWConstants.CSW_Service_NAME_STR);
      }
      else
      {
         getParameters.put(CSWKVPEncodingStrs.CSW_GET_RECORDS_KVP_KEY_SERVICE_STR, this.getService());
      }
      // Specify the csw version
      if(null == this.getVersion() || this.getVersion().toString().equals(""))
      {
         getParameters.put(CSWKVPEncodingStrs.CSW_GET_RECORDS_KVP_KEY_VERSION_STR, (new Version(2, 0, 2)).toString());
      }
      else
      {
         getParameters.put(CSWKVPEncodingStrs.CSW_GET_RECORDS_KVP_KEY_VERSION_STR, this.getVersion().toString());
      }
      // Specify the output format
      if(null == this.getOutputFormat() || this.getOutputFormat().equals(""))
      {
         getParameters.put(CSWKVPEncodingStrs.CSW_GET_RECORDS_KVP_KEY_OUTPUT_FORMAT_STR, CSWOutputFormatStrs.CSW_OUTPUT_FORMAT_APPICATION_XML_STR);
      }
      else
      {
         getParameters.put(CSWKVPEncodingStrs.CSW_GET_RECORDS_KVP_KEY_OUTPUT_FORMAT_STR, this.getOutputFormat().getStrName());
      }
      formatter.format("?");
      for(Iterator<Map.Entry<String, String>> it = getParameters.entrySet().iterator(); it.hasNext();)
      {
         Map.Entry<String, String> keyValuePair = it.next();
         formatter.format("%s=%s", keyValuePair.getKey(), keyValuePair.getValue());
         if(it.hasNext())
         {
            formatter.format("&");
         }
      }
      _toString = formatter.toString();
      formatter.close();
      return _toString;
   }

   @Override
   public String toString()
   {
      return this.getURLStr();
   }

   public URL getURL()
   {
      try
      {
         if(null != this.baseURL && !this.baseURL.equals(""))
         {
            return new URL(getURLStr());
         }
         else
         {
            return null;
         }
      }
      catch(MalformedURLException e)
      {
         logger.error("Malofrmed URL exception", e);
      }
      return null;
   }

   public String getURLStr()
   {
      if(null != this.baseURL && !this.baseURL.equals(""))
      {
    	  logger.debug("Base URL " + this.baseURL);
    	  logger.debug("URL component produced " + this.getGETMethodURLPartForAbstractCSWRequest());
         return this.baseURL + this.getGETMethodURLPartForAbstractCSWRequest();
      }
      return null;
   }

   public URL getBaseURL()
   {
      try
      {
         return null != this.baseURL && !this.baseURL.toString().equals("") ? new URL(this.getBaseURLStr()) : null;
      }
      catch(MalformedURLException e)
      {
         logger.error("Malofrmed URL exception", e);
      }
      return null;
   }

   public String getBaseURLStr()
   {
      return this.baseURL;
   }

   public void setBaseURL(String baseURL)
   {
      this.baseURL = baseURL;
   }

   public String getService()
   {
      return service;
   }

   public void setService(String service)
   {
      this.service = service;
   }

   public Version getVersion()
   {
      return version;
   }

   public void setVersion(Version version)
   {
      this.version = version;
   }

   public CSWOutputFormatEnum getOutputFormat()
   {
      return outputFormat;
   }

   public void setOutputFormat(CSWOutputFormatEnum outputFormat)
   {
      this.outputFormat = outputFormat;
   }
}
