package eu.dnetlib.espas.data.harvest;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.log4j.Logger;

// This class correponds to the "csw:Record" element.
public class Record
{
   {  // Class wide initialization.
      logger = Logger.getLogger(Record.class);
   }

   // "csw:SearchStatus" element.
   public static final String SS_ELEMENT_NAME = "SearchStatus";

   // "csw:SearchStatus" element attributes.
   public static final String SS_ATT_TIMESTAMP = "timestamp";

   // "csw:SearchResults" element search results.
   public static final String SR_ELEMENT_NAME = "SearchResults";

   // "csw:SearchResults" element attributes.
   public static final String SR_ATT_NUM_OF_RECORDS_RETUREND = "numberOfRecordsReturned";
   public static final String SR_ATT_NUM_OF_NEXT_RECORD = "nextRecord";
   public static final String SR_ATT_NUM_OF_RECORDS_MATCHED = "numberOfRecordsMatched";

   // "csw:Record" element prefix name.
   public static final String REC_PREFIX_NAME = "csw";

   // "csw:Record" element name.
   public static final String REC_ELEMENT_NAME = "record";

   // "dc:identifier" element name and prefix.
   public static final String IDENTIFIER_ELEMENT_PREFIX = "dc";
   public static final String IDENTIFIER_ELEMENT_NAME = "identifier";

   // "dc:type" element name and prefix.
   public static final String TYPE_SUBELEMENT_PREFIX = "dc";
   public static final String TYPE_ELEMENT_NAME = "type";

   // "dc:title" element name and prefix.
   public static final String TITLE_SUBELEMENT_PREFIX = "dc";
   public static final String TITLE_ELEMENT_NAME = "title";

   // "dct:spatial" element name and prefix.
   public static final String SPATIAL_SUBELEMENT_PREFIX = "dct";
   public static final String SPATIAL_ELEMENT_NAME = "spatial";

   // "dc:date" element name and prefix.
   public static final String DATE_SUBELEMENT_PREFIX = "dc";
   public static final String DATE_ELEMENT_NAME = "date";

   // "dc:relation" element name and prefix.
   public static final String RELATION_SUBELEMENT_PREFIX = "dc";
   public static final String RELATION_ELEMENT_NAME = "relation";

   // "dc:format" element name.
   public static final String FORMAT_SUBELEMENT_PREFIX = "dc";
   public static final String FORMAT_ELEMENT_NAME = "format";

   // "dc:abstract" element name and prefix.
   public static final String ABSTRACT_SUBELEMENT_PREFIX = "dct";
   public static final String ABSTRACT_ELEMENT_NAME = "abstract";

   private static Logger logger = Logger.getLogger(Record.class);

   // This object instance attribute corresponds to the "csw:Record" element attributes.
   private Map<String, String> recAttributes = null;

   // This object instance attribute corresponds to the "dc:identifier" element.
   private String recIdentifier = null;

   // This object instance attribute corresponds to the "dc:type" element.
   private String recType = null;

   // This object instnace attribute corresponds to the "dc:title" element.
   private String recTitle = null;

   // This object instnace attribute corresponds to the "dct:spatial" element.
   private String recSpatial = null;

   // This object instnace attribute corresponds to the "dc:date" element.
   private String recDate = null;

   // This object instnace attribute corresponds to the "dc:subject" element.
   private Subject recSubject = null;

   // This object instnace attribute corresponds to the "dc:relation" element.
   private String recRelation = null;

   // This object instnace attribute corresponds to the "dc:format" element.
   private String recFormat = null;

   // This object instnace attribute corresponds to the "dc:abstract" element.
   private String recAbstract = null;

   // This object instnace attribute corresponds to the "ows:BoundingBox" element.
   private BoundingBox recBoundingBox = null;

   public Record()
   {
      this.recAttributes = new LinkedHashMap<String, String>();
   }

   @Override
   public String toString()
   {
	  String _toString = null;
      Formatter formatter = new Formatter();
      formatter.format("<%s:%s>", REC_PREFIX_NAME, REC_ELEMENT_NAME);
      if(null != this.recIdentifier && !this.recIdentifier.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", IDENTIFIER_ELEMENT_PREFIX, IDENTIFIER_ELEMENT_NAME);
         formatter.format("%s", this.recIdentifier);
         formatter.format("</%s:%s>", IDENTIFIER_ELEMENT_PREFIX, IDENTIFIER_ELEMENT_NAME);
      }
      if(null != this.recType && !this.recType.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", TYPE_SUBELEMENT_PREFIX, TYPE_ELEMENT_NAME);
         formatter.format("%s", this.recType);
         formatter.format("</%s:%s>", TYPE_SUBELEMENT_PREFIX, TYPE_ELEMENT_NAME);
      }
      if(null != this.recTitle && !this.recTitle.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", TITLE_SUBELEMENT_PREFIX, TITLE_ELEMENT_NAME);
         formatter.format("%s", this.recTitle);
         formatter.format("</%s:%s>", TITLE_SUBELEMENT_PREFIX, TITLE_ELEMENT_NAME);
      }
      if(null != this.recSpatial && !this.recSpatial.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", SPATIAL_SUBELEMENT_PREFIX, SPATIAL_ELEMENT_NAME);
         formatter.format("%s", this.recSpatial);
         formatter.format("</%s:%s>", SPATIAL_SUBELEMENT_PREFIX, SPATIAL_ELEMENT_NAME);
      }
      if(null != this.recDate && !this.recDate.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", DATE_SUBELEMENT_PREFIX, DATE_ELEMENT_NAME);
         formatter.format("%s", this.recDate);
         formatter.format("</%s:%s>", DATE_SUBELEMENT_PREFIX, DATE_ELEMENT_NAME);
      }
      if(null != this.recSubject && !this.recSubject.toString().equalsIgnoreCase(""))
      {
         formatter.format("%s", this.recSubject.toString());
      }
      if(null != this.recRelation && !this.recRelation.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", RELATION_SUBELEMENT_PREFIX, RELATION_ELEMENT_NAME);
         formatter.format("%s", this.recRelation);
         formatter.format("</%s:%s>", RELATION_SUBELEMENT_PREFIX, RELATION_ELEMENT_NAME);
      }
      if(null != this.recAbstract && !this.recAbstract.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", ABSTRACT_SUBELEMENT_PREFIX, ABSTRACT_ELEMENT_NAME);
         formatter.format("%s", this.recAbstract);
         formatter.format("</%s:%s>", ABSTRACT_SUBELEMENT_PREFIX, ABSTRACT_ELEMENT_NAME);
      }
      if(null != this.recFormat && !this.recFormat.equalsIgnoreCase(""))
      {
         formatter.format("<%s:%s>", FORMAT_SUBELEMENT_PREFIX, FORMAT_ELEMENT_NAME);
         formatter.format("%s", this.recFormat);
         formatter.format("</%s:%s>", FORMAT_SUBELEMENT_PREFIX, FORMAT_ELEMENT_NAME);
      }
      if(null != this.recBoundingBox && !this.recBoundingBox.toString().equalsIgnoreCase(""))
      {
         formatter.format("%s", this.recBoundingBox.toString());
      }
      formatter.format("</%s:%s>", REC_PREFIX_NAME, REC_ELEMENT_NAME);
      logger.info(formatter.toString());
      _toString = formatter.toString();
      formatter.close();
      return _toString;
   }

   public String toBeautifiedString()
   {
	  String _toString = null;
      Formatter formatter = new Formatter();
      try
      {
         String record = null;
         TransformerFactory transformerFactory = TransformerFactory.newInstance();
         transformerFactory.setAttribute("indent-number", 3);
         Transformer transformer = transformerFactory.newTransformer();
         transformer.setOutputProperty(OutputKeys.INDENT, "yes");
         record = AbstractRecordsHarvester.CSW_GET_RECORD_RESPONSE_START_DOC + this.toString();
         record = record + AbstractRecordsHarvester.CSW_GET_RECORD_RESPONSE_END_DOC;
         Source xmlInput = new StreamSource(new StringReader(record));
         StreamResult xmlOutput = new StreamResult(new StringWriter());
         transformer.transform(xmlInput, xmlOutput);
         formatter.format("%s\n", xmlOutput.getWriter().toString());
         logger.info(formatter.toString());
      }
      catch(TransformerConfigurationException e)
      {
         logger.error("Transformer configuration exception.", e);
      }
      catch(TransformerException e)
      {
         logger.error("Transformer configuration exception.", e);
      }
      _toString = formatter.toString();
      formatter.close();
      return _toString;
   }

   @Override
   public boolean equals(Object object)
   {
      boolean equals = true;
      if(this == object)
      {
         return true;
      }
      if(!(object instanceof Record))
      {
         return false;
      }
      Record record = (Record)object;

      if(null != this.recAttributes && !(equals = equals && this.recAttributes.equals(record.getRecAttributes())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recAttributes && null != record.getRecAttributes())))
      {
         return equals;
      }

      if(null != this.recIdentifier && !(equals = equals && this.recIdentifier.equalsIgnoreCase(record.getRecIdentifier())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recIdentifier && null != record.getRecIdentifier())))
      {
         return equals;
      }

      if(null != this.recType && !(equals = equals && this.recType.equalsIgnoreCase(record.getRecType())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recType && null != record.getRecType())))
      {
         return equals;
      }

      if(null != this.recTitle && !(equals = equals && this.recTitle.equalsIgnoreCase(record.getRecTitle())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recTitle && null != record.getRecTitle())))
      {
         return equals;
      }

      if(null != this.recSpatial && !(equals = equals && this.recSpatial.equalsIgnoreCase(record.getRecSpatial())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recSpatial && null != record.getRecSpatial())))
      {
         return equals;
      }

      if(null != this.recSubject && !(equals = equals && this.recSubject.equals(record.getRecSubject())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recSubject && null != record.getRecSubject())))
      {
         return equals;
      }

      if(null != this.recRelation && !(equals = equals && this.recRelation.equals(record.getRecRelation())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recRelation && null != record.getRecRelation())))
      {
         return equals;
      }

      if(null != this.recFormat && !(equals = equals && this.recFormat.equals(record.getRecFormat())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recFormat && null != record.getRecFormat())))
      {
         return equals;
      }

      if(null != this.recAbstract && !(equals = equals && this.recAbstract.equals(record.getRecAbstract())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.recAbstract && null != record.getRecAbstract())))
      {
         return equals;
      }

      return equals;
   }

   public Map<String, String> getRecAttributes()
   {
      return recAttributes;
   }

   public String getRecAttributeValue(String key)
   {
      return this.recAttributes.get(key);
   }

   public void setRecAttributes(Map<String, String> recAttributes)
   {
      this.recAttributes = recAttributes;
   }

   public void put(String key, String value)
   {
      this.recAttributes.put(key, value);
   }

   public String getRecIdentifier()
   {
      return recIdentifier;
   }

   public void setRecIdentifier(String recIdentifier)
   {
      this.recIdentifier = recIdentifier;
   }

   public String getRecType()
   {
      return recType;
   }

   public void setRecType(String recType)
   {
      this.recType = recType;
   }

   public String getRecTitle()
   {
      return recTitle;
   }

   public void setRecTitle(String recTitle)
   {
      this.recTitle = recTitle;
   }

   public String getRecSpatial()
   {
      return recSpatial;
   }

   public void setRecSpatial(String recSpatial)
   {
      this.recSpatial = recSpatial;
   }

   public String getRecDate()
   {
      return recDate;
   }

   public void setRecDate(String recDate)
   {
      this.recDate = recDate;
   }

   public Subject getRecSubject()
   {
      return recSubject;
   }

   public void setRecSubject(Subject recSubject)
   {
      this.recSubject = recSubject;
   }

   public String getRecRelation()
   {
      return recRelation;
   }

   public void setRecRelation(String recRelation)
   {
      this.recRelation = recRelation;
   }

   public String getRecFormat()
   {
      return recFormat;
   }

   public void setRecFormat(String recFormat)
   {
      this.recFormat = recFormat;
   }

   public String getRecAbstract()
   {
      return recAbstract;
   }

   public void setRecAbstract(String recAbstract)
   {
      this.recAbstract = recAbstract;
   }

   public BoundingBox getRecBoundingBox()
   {
      return recBoundingBox;
   }

   public void setRecBoundingBox(BoundingBox recBoundingBox)
   {
      this.recBoundingBox = recBoundingBox;
   }
}
