package eu.dnetlib.espas.data.harvest.csw.common;

   /**
    * Specifies the mode of the response that is requested. The modes are: <br>
    * <li>hits (default)</li> <li>results</li> <li>validate</li> <br>
    */
public enum CSWResultSetTypeEnum
{
   /**
    * returns an empty SearchResults element that include the size of the
    * result set. This is the default result set type, if there has not been
    * specified one.
    */
   HITS(CSWResutlSetTypeStrs.CSW_RESULT_TYPE_HITS),
   /**
    * returns one or more records from the result set up to the maximum
    * number of records specified in the request
    */
   RESULTS(CSWResutlSetTypeStrs.CSW_RESULT_TYPE_RESULTS),
   /** validates the request message */
   VALIDATE(CSWResutlSetTypeStrs.CSW_RESULT_TYPE_VALIDATE);

   private final String strName;

   CSWResultSetTypeEnum(String strName)
   {
      this.strName = strName;
   }

   public String getStrName()
   {
      return this.strName;
   }
}
