package eu.dnetlib.espas.data.harvest.service;

import org.apache.log4j.Logger;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.espas.data.harvest.RecordsConsumer;

public class CSWJobListener extends
		BlackboardNotificationHandler<BlackboardServerHandler> {
	{ // Class wide initialization.
		logger = Logger.getLogger(CSWJobListener.class);
	}
	private static Logger logger = null;
	private RecordsConsumer recordsConsumer = null;

	@Override
	protected void processJob(BlackboardJob job) {
		logger.info("Start processing the just received blackboard job.");
		recordsConsumer.setCswJobListener(this);
		recordsConsumer.setJob(job);
		// Use the same thread pool for the records consumer.
		recordsConsumer.getCswHarvester().getExecutorService().execute(recordsConsumer);
	}

	public RecordsConsumer getRecordsConsumer() {
		return recordsConsumer;
	}

	public void setRecordsConsumer(RecordsConsumer recordsConsumer) {
		this.recordsConsumer = recordsConsumer;
	}
}
