/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.data.harvest;

import eu.dnetlib.api.enabling.ResultSetService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.espas.data.harvest.CSWHarvester;
import eu.dnetlib.espas.data.harvest.RecordsConsumer;
import eu.dnetlib.espas.data.harvest.RecordsHarvesterTransImpl;
import eu.dnetlib.espas.data.harvest.csw.CSWGetRecordsRequest;
import eu.dnetlib.espas.data.harvest.csw.common.CSWConstants;
import eu.dnetlib.espas.data.harvest.csw.common.CSWOutputFormatEnum;
import eu.dnetlib.espas.data.harvest.csw.common.CSWResultSetTypeEnum;
import eu.dnetlib.espas.data.harvest.service.CSWJobListener;
import eu.dnetlib.utils.EPRUtils;
import gr.uoa.di.driver.util.ServiceLocator;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class RecordsConsumerTransImpl
implements RecordsConsumer {
    public static int DEFAULT_BATCH_SIZE = 100;
    public static int DEFAULT_NUM_OF_BATCH_SIZES = 3;
    private static Logger logger = null;
    private int batchSize;
    private int numOfBatchSizes;
    private CSWHarvester cswHarvester;
    CSWJobListener cswJobListener;
    private BlackboardJob job;
    private ServiceLocator<ResultSetService> resultSetServiceLocator;

    public RecordsConsumerTransImpl() {
        logger = Logger.getLogger(RecordsConsumerTransImpl.class);
        this.batchSize = DEFAULT_BATCH_SIZE;
        this.numOfBatchSizes = DEFAULT_NUM_OF_BATCH_SIZES;
        this.cswHarvester = null;
        this.cswJobListener = null;
        this.job = null;
        this.resultSetServiceLocator = null;
    }

    @Override
    public void consume() {
        if (!this.isRecordsConsumerValid()) {
            logger.debug((Object)"The Record consumer is not properly configured!");
            return;
        }
        try {
            if (this.job.getAction().equals("START-HARVESTING")) {
                logger.info((Object)"Start harvesting job.");
                String[] recordTypes = ((String)this.job.getParameters().get("RECORD-TYPE")).split(",");
                if (0 == recordTypes.length) {
                    throw new Exception("Passed list of record types is empty.");
                }
                LinkedList<CSWGetRecordsRequest> cswGetRecordsRequests = new LinkedList<CSWGetRecordsRequest>();
                for (int i = 0; i < recordTypes.length; ++i) {
                    CSWGetRecordsRequest cswGetRecordsRequest = new CSWGetRecordsRequest();
                    cswGetRecordsRequest.setBaseURL((String)this.job.getParameters().get("URL"));
                    cswGetRecordsRequest.setService("CSW");
                    cswGetRecordsRequest.setVersion(CSWConstants.VERSION_202);
                    cswGetRecordsRequest.setOutputFormat(CSWOutputFormatEnum.CSW_OUTPUT_FORMAT_APPLICATION_XML);
                    cswGetRecordsRequest.setOutputSchema("http://www.opengis.net/cat/csw/2.0.2");
                    cswGetRecordsRequest.setResultType(CSWResultSetTypeEnum.RESULTS);
                    cswGetRecordsRequest.setToDate((String)this.job.getParameters().get("TO-DATE"));
                    cswGetRecordsRequest.setFromDate((String)this.job.getParameters().get("FROM-DATE"));
                    cswGetRecordsRequest.setType(recordTypes[i].trim());
                    cswGetRecordsRequest.setStartPosition(1);
                    cswGetRecordsRequest.setMaxRecords(this.batchSize);
                    logger.debug((Object)("CSW Get Records Request\n" + cswGetRecordsRequest.toString()));
                    if (!cswGetRecordsRequest.isValid()) {
                        logger.error((Object)"Invalid request");
                        this.job.setAction("IDLE");
                        this.job.getParameters().put("HARVESTING-STATUS", "FAILED");
                        ((BlackboardServerHandler)this.cswJobListener.getBlackboardHandler()).failed(this.job, (Throwable)new Exception("Invalid " + CSWGetRecordsRequest.class.getCanonicalName() + "request."));
                        throw new Exception("Invalid CSW Get Records request.");
                    }
                    cswGetRecordsRequests.addLast(cswGetRecordsRequest);
                }
                logger.debug((Object)"Creating harvester.");
                RecordsHarvesterTransImpl recordsHarvester = new RecordsHarvesterTransImpl(this.numOfBatchSizes * this.batchSize, cswGetRecordsRequests);
                this.cswHarvester.execute(recordsHarvester);
                ResultSetService resultSetService = (ResultSetService)this.resultSetServiceLocator.getService();
                EPR epr = resultSetService.createPushRS(86400, 0);
                String resultSetID = epr.getParameter("ResourceIdentifier");
                logger.debug((Object)("CREATED RS: " + resultSetID));
                int numOfHarvestedRecords = 0;
                ArrayList<String> arrayList = new ArrayList<String>(0);
                for (String recordStr : recordsHarvester) {
                    logger.debug((Object)recordStr);
                    if (recordStr != null && !recordStr.isEmpty()) {
                        arrayList.add(recordStr);
                    }
                    if (arrayList.size() < this.batchSize) continue;
                    resultSetService.populateRS(resultSetID, arrayList);
                    logger.debug((Object)("Currently, batch harvested records [" + arrayList.size() + "]"));
                    logger.debug((Object)("Totally, harvested records [" + (numOfHarvestedRecords += arrayList.size()) + "]"));
                    arrayList.clear();
                    this.job.getParameters().put("NUM-OF-HARVESTED-RECORDS", Integer.toString(numOfHarvestedRecords));
                    this.job.getParameters().put("HARVESTING-STATUS", "RUNNING");
                    ((BlackboardServerHandler)this.cswJobListener.getBlackboardHandler()).ongoing(this.job);
                }
                if (arrayList.size() > 0) {
                    resultSetService.populateRS(resultSetID, arrayList);
                    logger.debug((Object)("Currently, batch harvested records [" + arrayList.size() + "]"));
                    logger.debug((Object)("Totally, harvested records [" + (numOfHarvestedRecords += arrayList.size()) + "]"));
                    arrayList.clear();
                    this.job.getParameters().put("NUM-OF-HARVESTED-RECORDS", Integer.toString(numOfHarvestedRecords));
                    this.job.getParameters().put("HARVESTING-STATUS", "RUNNING");
                    ((BlackboardServerHandler)this.cswJobListener.getBlackboardHandler()).ongoing(this.job);
                } else {
                    logger.debug((Object)"Records list is empty.");
                }
                resultSetService.closeRS(resultSetID);
                this.job.setAction("IDLE");
                String eprStr = EPRUtils.eprToXml((EPR)epr);
                if (logger.isDebugEnabled()) {
                    Formatter formatter = new Formatter();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    transformerFactory.setAttribute("indent-number", 3);
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    StreamSource xmlInput = new StreamSource(new StringReader(eprStr));
                    StreamResult xmlOutput = new StreamResult(new StringWriter());
                    transformer.transform(xmlInput, xmlOutput);
                    formatter.format("\n%s\n", xmlOutput.getWriter().toString());
                    logger.debug((Object)formatter.toString());
                    formatter.close();
                }
                logger.info((Object)"Harvesting completed.");
                logger.debug((Object)("EPR: " + this.eprToDNETUrl(eprStr)));
                this.job.getParameters().put("RESULT-SET-EPR", this.eprToDNETUrl(eprStr));
                this.job.getParameters().put("HARVESTING-STATUS", "COMPLETED");
                this.job.getParameters().put("CSW-SEARCH-STATUS-TIMESTAMP", recordsHarvester.getCSWGetRecordsRequest().getLast().getSearchStatus().get("timestamp"));
                logger.info((Object)"updating blackboard.");
                ((BlackboardServerHandler)this.cswJobListener.getBlackboardHandler()).done(this.job);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Fatal exception, harvesting failed.", (Throwable)e);
            this.job.getParameters().put("HARVESTING-STATUS", "FAILED");
            ((BlackboardServerHandler)this.cswJobListener.getBlackboardHandler()).failed(this.job, (Throwable)e);
        }
    }

    public boolean isRecordsConsumerValid() {
        boolean isValid = true;
        logger.info((Object)("Configured batch size is [" + this.batchSize + "]"));
        boolean bl = isValid = isValid && this.batchSize > 0;
        if (!isValid) {
            return isValid;
        }
        boolean bl2 = isValid = isValid && null != this.cswHarvester;
        if (!isValid) {
            return isValid;
        }
        boolean bl3 = isValid = isValid && null != this.cswJobListener;
        if (!isValid) {
            return isValid;
        }
        boolean bl4 = isValid = isValid && null != this.job;
        if (!isValid) {
            return isValid;
        }
        boolean bl5 = isValid = isValid && null != this.resultSetServiceLocator;
        if (!isValid) {
            return isValid;
        }
        return isValid;
    }

    @Override
    public void run() {
        this.consume();
    }

    private String eprToDNETUrl(String eprXml) throws UnsupportedEncodingException {
        eprXml = URLEncoder.encode(eprXml, "UTF-8").replace("+", "%20");
        return eprXml;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public int getNumOfBatchSizes() {
        return this.numOfBatchSizes;
    }

    public void setNumOfBatchSizes(int numOfBatchSizes) {
        this.numOfBatchSizes = numOfBatchSizes;
    }

    @Override
    public CSWHarvester getCswHarvester() {
        return this.cswHarvester;
    }

    @Override
    public void setCswHarvester(CSWHarvester cswHarvester) {
        this.cswHarvester = cswHarvester;
    }

    @Override
    public CSWJobListener getCswJobListener() {
        return this.cswJobListener;
    }

    @Override
    public void setCswJobListener(CSWJobListener cswJobListener) {
        this.cswJobListener = cswJobListener;
    }

    @Override
    public BlackboardJob getJob() {
        return this.job;
    }

    @Override
    public void setJob(BlackboardJob job) {
        this.job = job;
    }

    @Override
    public ServiceLocator<ResultSetService> getResultSetServiceLocator() {
        return this.resultSetServiceLocator;
    }

    @Override
    public void setResultSetServiceLocator(ServiceLocator<ResultSetService> resultSetServiceLocator) {
        this.resultSetServiceLocator = resultSetServiceLocator;
    }
}

