/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.data.harvest;

import eu.dnetlib.espas.data.harvest.AbstractRecordsHarvester;
import eu.dnetlib.espas.data.harvest.RecordsHarvester;
import eu.dnetlib.espas.data.harvest.csw.CSWGetRecordsRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;

public class RecordsHarvesterTransImpl
extends AbstractRecordsHarvester
implements RecordsHarvester {
    protected static final int MAX_QUEUE_SIZE = Integer.MAX_VALUE;
    private Logger logger = Logger.getLogger(RecordsHarvesterTransImpl.class);
    protected LinkedList<CSWGetRecordsRequest> cswGetRecordsRequests = null;
    protected int maxQueueSize = Integer.MAX_VALUE;
    protected int numOfHarvestedRecords = 0;
    protected BlockingQueue<String> recordsBlockingQueue = null;
    protected boolean isHarvestingCompleted = false;

    @Override
    public void run() {
        this.harvest();
    }

    public RecordsHarvesterTransImpl() {
        this.initializeGetRecords(Integer.MAX_VALUE, null);
    }

    public RecordsHarvesterTransImpl(LinkedList<CSWGetRecordsRequest> cswGetRecordsRequest) {
        this.initializeGetRecords(Integer.MAX_VALUE, cswGetRecordsRequest);
    }

    public RecordsHarvesterTransImpl(int queueSize, LinkedList<CSWGetRecordsRequest> cswGetRecordsRequest) {
        this.initializeGetRecords(queueSize, cswGetRecordsRequest);
    }

    public void initializeGetRecords(int queueSize, LinkedList<CSWGetRecordsRequest> cswGetRecordsRequests) {
        this.setMaxQueueSize(queueSize);
        this.numOfHarvestedRecords = 0;
        this.recordsBlockingQueue = new LinkedBlockingQueue<String>(this.maxQueueSize);
        this.setCSWGetRecordsRequest(cswGetRecordsRequests);
        this.setHarvestingCompleted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void harvest() {
        try {
            for (CSWGetRecordsRequest cswGetRecordsRequest : this.cswGetRecordsRequests) {
                this.harvestEachRecordTypeIndividuallyInFIFO(cswGetRecordsRequest);
                this.numOfHarvestedRecords = (int)((long)this.numOfHarvestedRecords + cswGetRecordsRequest.getNumOfHarvestedRecords());
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Untreated Exception while harvesting", (Throwable)ex);
        }
        finally {
            this.isHarvestingCompleted = true;
        }
    }

    public void harvestEachRecordTypeIndividuallyInFIFO(CSWGetRecordsRequest cswGetRecordsRequest) {
        boolean isFirstGetRecordsRequest = true;
        cswGetRecordsRequest.getSearchResults().put("nextRecord", "1");
        while (Integer.parseInt(cswGetRecordsRequest.getSearchResults().get("nextRecord")) != 0) {
            if (isFirstGetRecordsRequest) {
                this.harvestTheNextCSWRecordsDocument(cswGetRecordsRequest);
                isFirstGetRecordsRequest = false;
                if (cswGetRecordsRequest.getNumOfHarvestedRecords() < (long)Integer.parseInt(cswGetRecordsRequest.getSearchResults().get("numberOfRecordsMatched"))) continue;
                this.logger.debug((Object)("Harvesting completed, expected[" + cswGetRecordsRequest.getSearchResults().get("numberOfRecordsMatched") + "] " + "actual[" + cswGetRecordsRequest.getNumOfHarvestedRecords() + "]"));
                return;
            }
            cswGetRecordsRequest.setStartPosition(Integer.parseInt(cswGetRecordsRequest.getSearchResults().get("nextRecord")));
            this.harvestTheNextCSWRecordsDocument(cswGetRecordsRequest);
            if (cswGetRecordsRequest.getNumOfHarvestedRecords() < (long)Integer.parseInt(cswGetRecordsRequest.getSearchResults().get("numberOfRecordsMatched"))) continue;
            this.logger.debug((Object)("Harvesting completed, expected[" + cswGetRecordsRequest.getSearchResults().get("numberOfRecordsMatched") + "] " + "actual[" + cswGetRecordsRequest.getNumOfHarvestedRecords() + "]"));
            return;
        }
    }

    public void harvestTheNextCSWRecordsDocument(CSWGetRecordsRequest cswGetRecordsRequest) {
        XMLInputFactory xmlInputFactory = null;
        XMLStreamReader xmlStreamReader = null;
        TransformerFactory transformerFactory = null;
        Transformer transformer = null;
        try {
            InputStream inputStream = cswGetRecordsRequest.getURL().openStream();
            xmlInputFactory = XMLInputFactory.newInstance();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(inputStream);
            transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            this.logger.debug((Object)("CSW GET Records request " + cswGetRecordsRequest.toString()));
            while (xmlStreamReader.hasNext()) {
                xmlStreamReader.next();
                if (1 == xmlStreamReader.getEventType() && "SearchStatus".equalsIgnoreCase(xmlStreamReader.getLocalName()) && cswGetRecordsRequest.getSearchStatus().isEmpty()) {
                    cswGetRecordsRequest.setSearchStatus(xmlStreamReader);
                    continue;
                }
                if (1 == xmlStreamReader.getEventType() && "SearchResults".equalsIgnoreCase(xmlStreamReader.getLocalName())) {
                    cswGetRecordsRequest.setSearchResults(xmlStreamReader);
                    continue;
                }
                if (1 != xmlStreamReader.getEventType() || !"record".equalsIgnoreCase(xmlStreamReader.getLocalName())) continue;
                ByteArrayOutputStream baosRecord = new ByteArrayOutputStream();
                transformer.transform(new StAXSource(xmlStreamReader), new StreamResult(baosRecord));
                this.put(baosRecord.toString());
                cswGetRecordsRequest.incrementNumOfHarvestedRecordsByOne();
            }
            inputStream.close();
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)("The passed url " + cswGetRecordsRequest.getURLStr() + " is malformed."), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"IO exception.", (Throwable)e);
        }
        catch (XMLStreamException e) {
            this.logger.error((Object)"XML stream exception.", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            this.logger.error((Object)"Transformer configuration exception.", (Throwable)e);
        }
        catch (TransformerException e) {
            this.logger.error((Object)"Transformer exception.", (Throwable)e);
        }
    }

    public String toString() {
        String _toString = null;
        Formatter formatter = new Formatter();
        for (String record : this.recordsBlockingQueue) {
            formatter.format("%s\n", record);
        }
        this.logger.debug((Object)formatter.toString());
        _toString = formatter.toString();
        formatter.close();
        return _toString;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getNumOfHarvestedRecords() {
        return this.numOfHarvestedRecords;
    }

    public void setNumOfHarvestedRecords(int numOfHarvestedRecords) {
        this.numOfHarvestedRecords = numOfHarvestedRecords;
    }

    @Override
    public BlockingQueue<String> getRecordsBlockingQueue() {
        return this.recordsBlockingQueue;
    }

    public void setRecordsBlockingQueue(BlockingQueue<String> records) {
        this.recordsBlockingQueue = records;
    }

    @Override
    public void put(String value) {
        try {
            this.logger.debug((Object)("Before put value: " + value));
            this.recordsBlockingQueue.put(value);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"Interrupted exception.", (Throwable)e);
        }
    }

    @Override
    public String take() {
        String value = null;
        try {
            while (null == value && this.hasNext()) {
                this.logger.debug((Object)"Before take value");
                value = this.recordsBlockingQueue.poll(100L, TimeUnit.MILLISECONDS);
                this.logger.debug((Object)"poll timed out");
            }
            return value;
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"Interrupted exception.", (Throwable)e);
            return null;
        }
    }

    @Override
    public int size() {
        return this.recordsBlockingQueue.size();
    }

    @Override
    public boolean hasNext() {
        if (this.isHarvestingCompleted) {
            return this.recordsBlockingQueue.size() >= 1;
        }
        return true;
    }

    @Override
    public String next() {
        return this.take();
    }

    @Override
    public void remove() {
        this.take();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public void setCSWGetRecordsRequest(LinkedList<CSWGetRecordsRequest> cswGetRecordsRequests) {
        this.cswGetRecordsRequests = cswGetRecordsRequests;
    }

    @Override
    public LinkedList<CSWGetRecordsRequest> getCSWGetRecordsRequest() {
        return this.cswGetRecordsRequests;
    }

    @Override
    public boolean isHarvestingCompleted() {
        return this.isHarvestingCompleted;
    }

    @Override
    public void setHarvestingCompleted(boolean isHarvestingCompleted) {
        this.isHarvestingCompleted = isHarvestingCompleted;
    }
}

