/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.data.harvest.csw;

import eu.dnetlib.espas.data.harvest.csw.common.CSWConstants;
import eu.dnetlib.espas.data.harvest.csw.common.CSWOutputFormatEnum;
import eu.dnetlib.espas.data.harvest.csw.common.Version;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCSWRequest {
    private static Logger logger = null;
    private String baseURL;
    private String service;
    private Version version;
    private CSWOutputFormatEnum outputFormat;

    public AbstractCSWRequest() {
        logger = Logger.getLogger(AbstractCSWRequest.class);
        this.baseURL = null;
        this.service = null;
        this.version = null;
        this.baseURL = null;
        this.service = "CSW";
        this.version = CSWConstants.VERSION_202;
        this.outputFormat = CSWOutputFormatEnum.CSW_OUTPUT_FORMAT_APPLICATION_XML;
    }

    public AbstractCSWRequest(String baseURL, String service, Version version, CSWOutputFormatEnum outputFormat) {
        logger = Logger.getLogger(AbstractCSWRequest.class);
        this.baseURL = null;
        this.service = null;
        this.version = null;
        this.setBaseURL(baseURL);
        this.version = version;
        this.outputFormat = outputFormat;
    }

    private String getGETMethodURLPartForAbstractCSWRequest() {
        String _toString = null;
        Formatter formatter = new Formatter();
        LinkedHashMap<String, String> getParameters = new LinkedHashMap<String, String>();
        if (null == this.getService() || this.getService().toString().equals("")) {
            getParameters.put("service", "CSW");
        } else {
            getParameters.put("service", this.getService());
        }
        if (null == this.getVersion() || this.getVersion().toString().equals("")) {
            getParameters.put("version", new Version(2, 0, 2).toString());
        } else {
            getParameters.put("version", this.getVersion().toString());
        }
        if (null == this.getOutputFormat() || this.getOutputFormat().equals("")) {
            getParameters.put("outputFormat", "appilcation/xml");
        } else {
            getParameters.put("outputFormat", this.getOutputFormat().getStrName());
        }
        formatter.format("?", new Object[0]);
        Iterator it = getParameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry keyValuePair = it.next();
            formatter.format("%s=%s", keyValuePair.getKey(), keyValuePair.getValue());
            if (!it.hasNext()) continue;
            formatter.format("&", new Object[0]);
        }
        _toString = formatter.toString();
        formatter.close();
        return _toString;
    }

    public String toString() {
        return this.getURLStr();
    }

    public URL getURL() {
        try {
            if (null != this.baseURL && !this.baseURL.equals("")) {
                return new URL(this.getURLStr());
            }
            return null;
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Malofrmed URL exception", (Throwable)e);
            return null;
        }
    }

    public String getURLStr() {
        if (null != this.baseURL && !this.baseURL.equals("")) {
            logger.debug((Object)("Base URL " + this.baseURL));
            logger.debug((Object)("URL component produced " + this.getGETMethodURLPartForAbstractCSWRequest()));
            return this.baseURL + this.getGETMethodURLPartForAbstractCSWRequest();
        }
        return null;
    }

    public URL getBaseURL() {
        try {
            return null != this.baseURL && !this.baseURL.toString().equals("") ? new URL(this.getBaseURLStr()) : null;
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Malofrmed URL exception", (Throwable)e);
            return null;
        }
    }

    public String getBaseURLStr() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public CSWOutputFormatEnum getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(CSWOutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
    }
}

