/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.data.harvest.csw.common;

import eu.dnetlib.espas.data.harvest.csw.common.InvalidParameterValueException;

public class Version
implements Comparable<Version> {
    private final int x;
    private final int y;
    private final int z;

    public Version(int x, int y, int z) throws InvalidParameterValueException {
        if (x < 0 || y < 0 || z < 0 || y > 99 || z > 99) {
            String msg = x + "." + y + "." + z + " is not a valid OGC/OWS version value.";
            throw new InvalidParameterValueException(msg);
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Version parseVersion(String string) throws InvalidParameterValueException {
        String[] parts = string.split("\\.");
        if (parts.length != 3) {
            String msg = "String '" + string + " is not a valid OGC/OWS version value.";
            throw new InvalidParameterValueException(msg);
        }
        int x = -1;
        int y = -1;
        int z = -1;
        try {
            x = Integer.parseInt(parts[0]);
            y = Integer.parseInt(parts[1]);
            z = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException e) {
            String msg = "String '" + string + " is not a valid OGC/OWS version value.";
            throw new InvalidParameterValueException(msg);
        }
        return new Version(x, y, z);
    }

    @Override
    public int compareTo(Version version) {
        if (this.x > version.x) {
            return 1;
        }
        if (this.x < version.x) {
            return -1;
        }
        if (this.y > version.y) {
            return 1;
        }
        if (this.y < version.y) {
            return -1;
        }
        if (this.z > version.z) {
            return 1;
        }
        if (this.z < version.z) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 7 * (this.x + 1);
        hash *= 11 * (this.y + 1);
        return hash *= 13 * (this.z + 1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version that = (Version)obj;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public String toString() {
        return this.x + "." + this.y + "." + this.z;
    }

    public static String getVersionsString(Version ... versions) {
        int i = 0;
        StringBuilder s = new StringBuilder();
        for (Version version : versions) {
            s.append("'").append(version).append("'");
            if (i++ == versions.length - 1) continue;
            s.append(", ");
        }
        return s.toString();
    }
}

