package eu.dnetlib.espas.data.harvest;

import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.Map;

public class BoundingBox
{
   // "ows:BoundingBox" prefix
   public static final String BB_OWS_PREFIX = "ows";
   // "ows:BoundingBox" element attributes.
   public static final String BB_CRS_ELEMENT_ATTRIBUTE = "crs";
   // "ows:BoundingBox" element name.
   public static final String BB_ELEMENT_NAME_BOUNDING_BOX = "BoundingBox";
   public static final String BB_SUBELEMENT_NAME_LOWER_CORNER = "LowerCorner";
   public static final String BB_SUBELEMENT_NAME_UPPER_CORNER = "UpperCorner";

   private Map<String, String> bbAttributes = null;
   private double[] bbLowerCorner = null;
   private double[] bbUpperCorner = null;

   public BoundingBox()
   {
      this.bbAttributes = new LinkedHashMap<String, String>();
      this.bbLowerCorner = new double[0];
      this.bbUpperCorner = new double[0];
   }

   @Override
   public String toString()
   {
	  String _toString = null;
      Formatter formatter = new Formatter();
      formatter.format("<%s:%s", BB_OWS_PREFIX, BB_ELEMENT_NAME_BOUNDING_BOX);
      for(String key : this.bbAttributes.keySet())
      {
         formatter.format(" %s=\"%s\"", key, this.bbAttributes.get(key));
      }
      formatter.format(">");
      // Serialize the lower corner sub-element.
      formatter.format("<%s:%s>", BB_OWS_PREFIX, BB_SUBELEMENT_NAME_LOWER_CORNER);
      for(int i = 0; i < bbLowerCorner.length; i++)
      {
         formatter.format("%.3f", this.bbLowerCorner[i]);
         if(i < bbLowerCorner.length - 1)
            formatter.format(" ");
      }
      formatter.format("</%s:%s>", BB_OWS_PREFIX, BB_SUBELEMENT_NAME_LOWER_CORNER);
      // Serialize the upper corner sub-element.
      formatter.format("<%s:%s>", BB_OWS_PREFIX, BB_SUBELEMENT_NAME_UPPER_CORNER);
      for(int i = 0; i < bbUpperCorner.length; i++)
      {
         formatter.format("%.3f", this.bbUpperCorner[i]);
         if(i < bbUpperCorner.length - 1)
            formatter.format(" ");
      }
      formatter.format("</%s:%s>", BB_OWS_PREFIX, BB_SUBELEMENT_NAME_UPPER_CORNER);
      formatter.format("</%s:%s>", BB_OWS_PREFIX, BB_ELEMENT_NAME_BOUNDING_BOX);
      _toString = formatter.toString();
      formatter.close();
      return _toString;
   }

   @Override
   public boolean equals(Object object)
   {
      boolean equals = true;
      if(this == object)
      {
         return true;
      }
      if(!(object instanceof BoundingBox))
      {
         return false;
      }
      BoundingBox bbBoundingBox = (BoundingBox)object;

      if(null != this.bbAttributes && !(equals = equals && this.bbAttributes.equals(bbBoundingBox.getBbAttributes())))
      {
         return equals;
      }
      else if(!(equals = equals && !(null == this.bbAttributes && null != bbBoundingBox.getBbAttributes())))
      {
         return equals;
      }

      if(null != this.bbLowerCorner)
      {
         if(equals = equals && null != bbBoundingBox.getBbLowerCorner())
         {
            if(!(equals = equals && this.bbLowerCorner.length == bbBoundingBox.getBbLowerCorner().length))
            {
               return equals;
            }
            for(int i = 0; i < this.bbLowerCorner.length; i++)
            {
               if(!(equals = equals && this.bbLowerCorner[i] == bbBoundingBox.getBbLowerCorner()[i]))
               {
                  return equals;
               }
            }
         }
         else
         {
            return equals;
         }
      }
      else
      {
         if(!(equals = equals && null == bbBoundingBox.getBbLowerCorner()))
         {
            return equals;
         }
      }

      if(null != this.bbUpperCorner)
      {
         if(equals = equals && null != bbBoundingBox.getBbUpperCorner())
         {
            if(!(equals = equals && this.bbUpperCorner.length == bbBoundingBox.getBbUpperCorner().length))
            {
               return equals;
            }
            for(int i = 0; i < this.bbUpperCorner.length; i++)
            {
               if(!(equals = equals && this.bbUpperCorner[i] == bbBoundingBox.getBbUpperCorner()[i]))
               {
                  return equals;
               }
            }
         }
         else
         {
            return equals;
         }
      }
      else
      {
         if(!(equals = equals && null == bbBoundingBox.getBbUpperCorner()))
         {
            return equals;
         }
      }

      return equals;
   }

   public Map<String, String> getBbAttributes()
   {
      return bbAttributes;
   }

   public String getBBAttributeValue(String attributeName)
   {
      return this.bbAttributes.get(attributeName);
   }

   public void setBbAttributes(Map<String, String> bbAttributes)
   {
      this.bbAttributes = bbAttributes;
   }

   public void put(String attributeName, String attributeValue)
   {
      this.bbAttributes.put(attributeName, attributeValue);
   }

   public double[] getBbLowerCorner()
   {
      return bbLowerCorner;
   }

   public void setBBLowerCorner(double[] bbLowerCorner)
   {
      this.bbLowerCorner = bbLowerCorner;
   }

   public double[] getBbUpperCorner()
   {
      return bbUpperCorner;
   }

   public void setBBUpperCorner(double[] bbUpperCorner)
   {
      this.bbUpperCorner = bbUpperCorner;
   }
}
