package eu.dnetlib.espas.data.harvest.csw.common;


/**
*
* Operations that is the webservice capable of <br>
* <li>GetCapabilities</li> <li>DescribeRecord</li> <li>GetRecords</li> <li>
* GetRecordById</li><li>Transaction</li> <br>
*/

public enum CSWRequestTypeEnum {
  // Retrieve the capabilities of the service.
  GetCapabilities(CSWRequestTypeStrs.CSW_REQUEST_TYPE_GET_CAPABILITIES),
  // Discover elements of the service
  DescribeRecord(CSWRequestTypeStrs.CSW_REQUEST_TYPE_DESCRIBE_RECORD),
  // Resource discovery combines the two operations - search and present
  GetRecords(CSWRequestTypeStrs.CSW_REQUEST_TYPE_GET_RECORDS),
  // Retrieve the default representation of the service
  GetRecordById(CSWRequestTypeStrs.CSW_REQUEST_TYPE_GET_RECORD_BY_ID),
  // Creates, modifys and deletes catalogue records
  Transaction(CSWRequestTypeStrs.CSW_REQUEST_TYPE_TRANSACTION),
  GetRepositoryItem(CSWRequestTypeStrs.CSW_REQUEST_TYPE_GET_REPOSITORY_ITEM);

  private final String strName;

  CSWRequestTypeEnum(String strName) {
     this.strName = strName;
  }

  public String getStrName() {
     return this.strName;
  }
}
