package eu.dnetlib.espas.data.harvest.csw.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

import org.apache.log4j.Logger;

public class CommonUtilities
{
   {  // Class wide initialization.
      Logger.getLogger(CommonUtilities.class);
   }

   private static Logger logger = Logger.getLogger(CommonUtilities.class);

   public static String convertStreamToString(InputStream inputStream, int bufferSize) throws IOException
   {
      if(null != inputStream)
      {
         Writer stringWriter = new StringWriter();

         char[] buffer = new char[bufferSize];
         try
         {
            Reader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int numOfChars;
            while((numOfChars = reader.read(buffer)) != -1)
            {
               stringWriter.write(buffer, 0, numOfChars);
            }
         }
         catch (IOException e)
         {
            logger.error("Input/Output exception", e);
         }
         finally
         {
            inputStream.close();
         }
         return stringWriter.toString();
      }
      else
      {
         return null;
      }
   }
}
