/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.data.harvest;

import eu.dnetlib.espas.data.harvest.RecordsHarvester;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CSWHarvester {
    public static final int POOL_AWAIT_TERMINATION_INTERVAL = 60;
    protected static Logger logger = null;
    protected ExecutorService executorService;

    public CSWHarvester() {
        logger = Logger.getLogger(CSWHarvester.class);
        this.executorService = null;
        this.initialize();
    }

    public void initialize() {
        this.executorService = Executors.newCachedThreadPool();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public void shutdownAndWaitTermination() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.error((Object)"Thread pool did not terminate!");
                }
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"Failed to shutdown the harvester's thead pool.", (Throwable)e);
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void execute(RecordsHarvester recordsHarvester) {
        this.executorService.execute(recordsHarvester);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

