/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.data.harvest.csw;

import eu.dnetlib.espas.data.harvest.csw.AbstractCSWRequest;
import eu.dnetlib.espas.data.harvest.csw.common.CSWConstants;
import eu.dnetlib.espas.data.harvest.csw.common.CSWOutputFormatEnum;
import eu.dnetlib.espas.data.harvest.csw.common.CSWRequestTypeEnum;
import eu.dnetlib.espas.data.harvest.csw.common.CSWResultSetTypeEnum;
import eu.dnetlib.espas.data.harvest.csw.common.Version;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class CSWGetRecordsRequest
extends AbstractCSWRequest {
    private static final int DEFAULT_START_POSITION = 1;
    private static final int DEFAULT_MAX_RECORDS = 10;
    private static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private static Logger logger = null;
    protected CSWRequestTypeEnum request;
    protected CSWResultSetTypeEnum resultType;
    protected URI outputSchema;
    protected UUID requestID;
    protected Date fromDate;
    protected Date toDate;
    protected String type;
    protected int startPosition;
    protected int maxRecords;
    protected Map<String, String> searchStatus;
    protected Map<String, String> searchResults;
    protected long numOfHarvestedRecords;
    protected boolean isValid;

    public CSWGetRecordsRequest() {
        super(null, "CSW", CSWConstants.VERSION_202, CSWOutputFormatEnum.CSW_OUTPUT_FORMAT_APPLICATION_XML);
        logger = Logger.getLogger(CSWGetRecordsRequest.class);
        this.request = null;
        this.resultType = null;
        this.outputSchema = null;
        this.requestID = null;
        this.fromDate = null;
        this.toDate = null;
        this.type = null;
        this.startPosition = 1;
        this.maxRecords = 10;
        this.searchStatus = null;
        this.searchResults = null;
        this.numOfHarvestedRecords = 0L;
        this.isValid = true;
        this.initialize(CSWResultSetTypeEnum.HITS, null, null, null, null, null, 1, 10, new HashMap<String, String>(), new HashMap<String, String>(), 0L);
    }

    public CSWGetRecordsRequest(String baseURL, String service, Version version, CSWOutputFormatEnum outputFormat, CSWResultSetTypeEnum resultType, URI outputSchema, UUID uuidRequestID, String fromDate, String toDate, String type, int startPosition, int maxRecords, Map<String, String> searchStatus, Map<String, String> searchResults, long numOfHarvestedRecords) {
        super(baseURL, service, version, outputFormat);
        logger = Logger.getLogger(CSWGetRecordsRequest.class);
        this.request = null;
        this.resultType = null;
        this.outputSchema = null;
        this.requestID = null;
        this.fromDate = null;
        this.toDate = null;
        this.type = null;
        this.startPosition = 1;
        this.maxRecords = 10;
        this.searchStatus = null;
        this.searchResults = null;
        this.numOfHarvestedRecords = 0L;
        this.isValid = true;
        this.initialize(resultType, outputSchema, uuidRequestID, fromDate, toDate, type, startPosition, maxRecords, searchStatus, searchResults, 0L);
    }

    public void initialize(CSWResultSetTypeEnum resultType, URI outputSchema, UUID requestID, String fromDate, String toDate, String type, int startPosition, int maxRecords, Map<String, String> searchStatus, Map<String, String> searchResults, long numOfHarvestedRecords) {
        this.setResultType(resultType);
        this.setOutputSchema(outputSchema);
        if (null == requestID) {
            requestID = UUID.randomUUID();
            logger.debug((Object)("Created UUID request id [" + requestID.toString() + "]"));
            this.setRequestID(requestID);
        } else {
            logger.debug((Object)("Passed UUID request id [" + requestID.toString() + "]"));
            this.setRequestID(requestID);
        }
        this.setFromDate(fromDate);
        this.setToDate(toDate);
        this.setType(type);
        this.setStartPosition(startPosition);
        this.setMaxRecords(maxRecords);
        this.setSearchStatus(searchStatus);
        this.setSearchResults(searchResults);
        this.setNumOfHarvestedRecords(numOfHarvestedRecords);
    }

    private String getGETMethodURLPartForCSWGetRecordsRequest() {
        Formatter formatter = null;
        LinkedHashMap<String, String> getParameters = new LinkedHashMap<String, String>();
        try {
            if (null == this.request) {
                getParameters.put("request", "GetRecords");
            } else {
                getParameters.put("request", this.request.getStrName());
            }
            if (null == this.resultType) {
                getParameters.put("resulttype", "hits");
            } else {
                getParameters.put("resulttype", this.resultType.getStrName());
            }
            if (null == this.outputSchema || this.outputSchema.toString().equals("")) {
                getParameters.put("outputSchema", new URI("http://www.opengis.net/cat/csw/2.0.2").toString());
            } else {
                getParameters.put("outputSchema", this.outputSchema.toString());
            }
            if (null == this.requestID) {
                this.requestID = UUID.randomUUID();
                logger.debug((Object)("Created UUID request id [" + this.requestID.toString() + "]"));
                getParameters.put("requestId", this.requestID.toString());
            } else {
                logger.debug((Object)("Passed UUID request id [" + this.requestID.toString() + "]"));
                getParameters.put("requestId", this.requestID.toString());
            }
            getParameters.put("CONSTRAINTLANGUAGE", "CQL_TEXT");
            if (null == this.fromDate || null == this.type) {
                this.isValid = false;
                getParameters.put("Constraint", "");
            } else {
                this.isValid = true;
                formatter = new Formatter();
                formatter.format("\"Type like '%s' and Modified between '%s' and '%s'\"", this.type, new DateUtils(this.fromDate).getDateAsISO8601String(), null != this.toDate ? new DateUtils(this.toDate).getDateAsISO8601String() : DateUtils.now_ISO8601());
                try {
                    getParameters.put("Constraint", URLEncoder.encode(formatter.toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)"Unsupported encoding exception", (Throwable)e);
                }
                formatter.close();
            }
            if (this.startPosition < 0) {
                getParameters.put("startPosition", Integer.toString(1));
            } else {
                getParameters.put("startPosition", Integer.toString(this.startPosition));
            }
            if (this.maxRecords < 0) {
                getParameters.put("maxRecords", Integer.toString(10));
            } else if (0 == this.maxRecords) {
                getParameters.put("maxRecords", Integer.toString(this.maxRecords));
                getParameters.put("resulttype", "hits");
            } else {
                getParameters.put("maxRecords", Integer.toString(this.maxRecords));
            }
            formatter = new Formatter();
            Iterator it = getParameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry keyValuePair = it.next();
                formatter.format("%s=%s", keyValuePair.getKey(), keyValuePair.getValue());
                if (!it.hasNext()) continue;
                formatter.format("&", new Object[0]);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return formatter.toString();
    }

    @Override
    public String toString() {
        return this.getURLStr();
    }

    @Override
    public URL getURL() {
        try {
            if (null != this.getURLStr() && !this.getURLStr().equals("")) {
                return new URL(this.getURLStr());
            }
            return null;
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Malofrmed URL exception", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getURLStr() {
        if (null != super.getURLStr() && !super.getURLStr().equals("")) {
            logger.debug((Object)("Passed URL from the AbstractCSWRequest " + super.getURLStr()));
            logger.debug((Object)("URL component produced " + this.getGETMethodURLPartForCSWGetRecordsRequest()));
            return super.getURLStr() + "&" + this.getGETMethodURLPartForCSWGetRecordsRequest();
        }
        return null;
    }

    public CSWRequestTypeEnum getRequest() {
        return this.request;
    }

    public void setRequest(CSWRequestTypeEnum request) {
        this.request = request;
    }

    public URI getOutputSchema() {
        return this.outputSchema;
    }

    public void setOutputSchema(URI outputSchema) {
        this.outputSchema = outputSchema;
    }

    public UUID getRequestID() {
        return this.requestID;
    }

    public void setRequestID(UUID requestID) {
        this.requestID = requestID;
    }

    public void setOutputSchema(String outputSchema) {
        try {
            this.outputSchema = new URI(outputSchema);
        }
        catch (URISyntaxException e) {
            logger.error((Object)"URI syntax exception", (Throwable)e);
        }
    }

    public synchronized Date checkISO8601Compliance(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        try {
            return ISO8601FORMAT.parse(dateStr);
        }
        catch (ParseException e) {
            this.isValid = false;
            logger.error((Object)("\"" + dateStr + "\"" + " is not compliant to ISO 8601."), (Throwable)e);
            return null;
        }
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = this.checkISO8601Compliance(fromDate);
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = this.checkISO8601Compliance(toDate);
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public CSWResultSetTypeEnum getResultType() {
        return this.resultType;
    }

    public void setResultType(CSWResultSetTypeEnum resultType) {
        this.resultType = resultType;
    }

    public Map<String, String> getSearchStatus() {
        return this.searchStatus;
    }

    public void setSearchStatus(XMLStreamReader xmlStreamReader) {
        int attributeListSize = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < attributeListSize; ++i) {
            this.searchStatus.put(xmlStreamReader.getAttributeLocalName(i), xmlStreamReader.getAttributeValue(i));
        }
    }

    public void setSearchStatus(Map<String, String> searchStatus) {
        this.searchStatus = searchStatus;
    }

    public Map<String, String> getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(XMLStreamReader xmlStreamReader) {
        int attributeListSize = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < attributeListSize; ++i) {
            this.searchResults.put(xmlStreamReader.getAttributeLocalName(i), xmlStreamReader.getAttributeValue(i));
        }
    }

    public void setSearchResults(Map<String, String> searchResults) {
        this.searchResults = searchResults;
    }

    public long getNumOfHarvestedRecords() {
        return this.numOfHarvestedRecords;
    }

    public void setNumOfHarvestedRecords(long numOfHarvestedRecords) {
        this.numOfHarvestedRecords = numOfHarvestedRecords;
    }

    public void incrementNumOfHarvestedRecordsByOne() {
        ++this.numOfHarvestedRecords;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }
}

