package eu.dnetlib.espas.data.harvest;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;

import eu.dnetlib.espas.data.harvest.csw.CSWGetRecordsRequest;

public interface RecordsHarvester extends Runnable
{
   public abstract BlockingQueue<String> getRecordsBlockingQueue();
   public abstract void setCSWGetRecordsRequest(LinkedList<CSWGetRecordsRequest> cswGetRecordRequests);
   public abstract LinkedList<CSWGetRecordsRequest> getCSWGetRecordsRequest();
   public abstract void harvest();
   public abstract int size();

   // Set/Get for the harvesting completed object attribute.
   public abstract boolean isHarvestingCompleted();
   public abstract void setHarvestingCompleted(boolean isHarvestingCompleted);

   // Expose the underlying BlockingQueue interface.
   public abstract void put(String string);
   public abstract String take();

   // Implements the iterator interface.
   public abstract Iterator<String> iterator();

   // Implements the iterable interface.
   public boolean hasNext();
   public String next();
   public void remove();
}
