package eu.dnetlib.espas.data.harvest.service;

import eu.dnetlib.api.data.CSHarvesterService;
import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import gr.uoa.di.driver.app.DriverServiceImpl;
import gr.uoa.di.driver.enabling.issn.NotificationListener;

import org.apache.log4j.Logger;

public class CSHarvesterServiceImpl extends DriverServiceImpl implements
		CSHarvesterService {
	{ // Class wide initialization.
		logger = Logger.getLogger(CSHarvesterServiceImpl.class);
	}
	private static Logger logger = null;
	private BlackboardNotificationHandler<BlackboardServerHandler> blackboardNotificationHandler = null;

	// do NOT call directly. It will be called by the
	// InitializingServiceRegistrationManager
	// after it sets the service EPR and id.
	@Override
	public void init() {
		super.init();
		this.subscribe(ActionType.UPDATE,
				ResourceType.CSHARVESTERSERVICERESOURCETYPE,
				this.getServiceEPR().getParameter("serviceId"),
				"RESOURCE_PROFILE/BODY/BLACKBOARD/LAST_REQUEST",
				new NotificationListener() {
					@Override
					public void processNotification(Notification notification) {
						blackboardNotificationHandler.notified(
								notification.getSubscriptionId(),
								notification.getTopic(),
								notification.getIsId(),
								notification.getMessage());
						logger.debug(notification.getSubscriptionId());
						logger.debug(notification.getTopic());
						logger.debug(notification.getIsId());
						logger.debug(notification.getMessage());
					}
				});
	}

	public BlackboardNotificationHandler<BlackboardServerHandler> getBlackboardNotificationHandler() {
		return blackboardNotificationHandler;
	}

	public void setBlackboardNotificationHandler(
			BlackboardNotificationHandler<BlackboardServerHandler> blackboardNotificationHandler) {
		this.blackboardNotificationHandler = blackboardNotificationHandler;
	}
}
