/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.data.harvest.csw.common;

import eu.dnetlib.espas.data.harvest.csw.common.MetadataStoreException;
import eu.dnetlib.espas.data.harvest.csw.common.Version;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;

public final class CSWConstants {
    public static final String CSW_202_NS = "http://www.opengis.net/cat/csw/2.0.2";
    public static final String ISO_19115_NS = "http://www.isotc211.org/2005/gmd";
    public static final String DC_NS = "http://purl.org/dc/elements/1.1/";
    public static final String DCT_NS = "http://purl.org/dc/terms/";
    public static final String DCT_PREFIX = "dct";
    public static final String APISO_NS = "http://www.opengis.net/cat/csw/apiso/1.0";
    public static final String GMD_NS = "http://www.isotc211.org/2005/gmd";
    public static final String SRV_NS = "http://www.isotc211.org/2005/srv";
    public static final String CSW_202_DISCOVERY_SCHEMA = "http://schemas.opengis.net/csw/2.0.2/CSW-discovery.xsd";
    public static final String CSW_202_PUBLICATION_SCHEMA = "http://schemas.opengis.net/csw/2.0.2/CSW-publication.xsd";
    public static final String CSW_202_RECORD = "http://schemas.opengis.net/csw/2.0.2/record.xsd";
    public static final String CSW_Service_NAME_STR = "CSW";
    public static final String CSW_PREFIX = "csw";
    public static final String GMD_PREFIX = "gmd";
    public static final String SRV_PREFIX = "srv";
    public static final String APISO_PREFIX = "apiso";
    public static final String DC_LOCAL_PART = "Record";
    public static final String DC_PREFIX = "dc";
    public static final String GMD_LOCAL_PART = "MD_Metadata";
    public static final String SRV_LOCAL_PART = "Service";
    public static final Version VERSION_202 = Version.parseVersion("2.0.2");
    public static final String VERSION_202_STRING = "2.0.2";
    public static final Version VERSION_100 = new Version(1, 0, 0);
    public static final String CSW_DEFAULT_APPLICATION_FORMAT = "application/xml";
    public static final String CSW_CQL_CONSTRAINT_LANGUAGE = "CQL_TEXT";

    public static enum OutputSchema {
        DC,
        ISO_19115;


        public static URI determineOutputSchema(OutputSchema outputSchema) throws MetadataStoreException {
            URI schema = null;
            try {
                switch (outputSchema) {
                    case DC: {
                        schema = new URI(CSWConstants.CSW_202_NS);
                        break;
                    }
                    case ISO_19115: {
                        schema = new URI("http://www.isotc211.org/2005/gmd");
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new MetadataStoreException(e.getMessage());
            }
            return schema;
        }

        public static OutputSchema determineByTypeName(QName typeName) {
            String uri = typeName.getNamespaceURI();
            if (uri.equals(CSWConstants.CSW_202_NS)) {
                return DC;
            }
            if (uri.equals("http://www.isotc211.org/2005/gmd")) {
                return ISO_19115;
            }
            return null;
        }
    }

    public static enum TransactionType {
        INSERT,
        DELETE,
        UPDATE;

    }

    public static enum ConstraintLanguage {
        CQLTEXT,
        FILTER;

    }

    public static enum ReturnableElement {
        brief,
        summary,
        full;


        public static ReturnableElement determineReturnableElement(String returnableElement) {
            ReturnableElement elementSetName = null;
            elementSetName = (returnableElement = returnableElement.toLowerCase()).equalsIgnoreCase(brief.name()) ? brief : (returnableElement.equalsIgnoreCase(summary.name()) ? summary : (returnableElement.equalsIgnoreCase(full.name()) ? full : summary));
            return elementSetName;
        }
    }

    public static enum Sections {
        ServiceIdentification,
        ServiceProvider,
        OperationsMetadata,
        Filter_Capabilities;

    }
}

