// $ANTLR 3.0.1 Cql.g3 2009-05-15 16:04:30

package eu.dnetlib.utils.cql;

import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;

public class CqlParser extends Parser {
	public static final String[] tokenNames = new String[] { "<invalid>",
			"<EOR>", "<DOWN>", "<UP>", "AND", "OR", "NOT", "PROX", "WITHIN",
			"IDENTIFIER", "STRING", "QUOTE", "WHITESPACE", "'>'", "'='", "'/'",
			"'('", "')'", "'<'", "'>='", "'<='", "'<>'" };

	public static final int QUOTE = 11;

	public static final int IDENTIFIER = 9;

	public static final int OR = 5;

	public static final int WITHIN = 8;

	public static final int PROX = 7;

	public static final int WHITESPACE = 12;

	public static final int NOT = 6;

	public static final int AND = 4;

	public static final int EOF = -1;

	public static final int STRING = 10;

	public CqlParser(TokenStream input) {
		super(input);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}

	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}

	public String[] getTokenNames() {
		return tokenNames;
	}

	public String getGrammarFileName() {
		return "Cql.g3";
	}

	@Override
	public void reportError(RecognitionException e) {
		throw new CqlRuntimeException("Parser Error", e);
	}

	public static class cql_return extends ParserRuleReturnScope {
		public CqlQuery query;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start cql
	// Cql.g3:35:1: cql returns [CqlQuery query] : q= cqlquery ;
	public final cql_return cql() throws RecognitionException {
		cql_return retval = new cql_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		cqlquery_return q = null;

		try {
			// Cql.g3:35:30: (q= cqlquery )
			// Cql.g3:35:32: q= cqlquery
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_cqlquery_in_cql87);
				q = cqlquery();
				_fsp--;

				adaptor.addChild(root_0, q.getTree());

				// System.out.println("query tree: " +
				// ((CommonTree)q.tree).toStringTree() );
				retval.query = q.query;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end cql

	public static class cqlquery_return extends ParserRuleReturnScope {
		public CqlQuery query;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start cqlquery
	// Cql.g3:43:1: cqlquery returns [CqlQuery query] : ( qscope q= cqlquery |
	// c= scopedClause );
	public final cqlquery_return cqlquery() throws RecognitionException {
		cqlquery_return retval = new cqlquery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		cqlquery_return q = null;

		scopedClause_return c = null;

		try {
			// Cql.g3:44:5: ( qscope q= cqlquery | c= scopedClause )
			int alt1 = 2;
			int LA1_0 = input.LA(1);

			if ((LA1_0 == 13)) {
				alt1 = 1;
			} else if (((LA1_0 >= AND && LA1_0 <= PROX)
					|| (LA1_0 >= IDENTIFIER && LA1_0 <= STRING) || LA1_0 == 16)) {
				alt1 = 2;
			} else {
				NoViableAltException nvae = new NoViableAltException(
						"43:1: cqlquery returns [CqlQuery query] : ( qscope q= cqlquery | c= scopedClause );",
						1, 0, input);

				throw nvae;
			}
			switch (alt1) {
			case 1:
				// Cql.g3:44:7: qscope q= cqlquery
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_qscope_in_cqlquery113);
				qscope();
				_fsp--;

				pushFollow(FOLLOW_cqlquery_in_cqlquery118);
				q = cqlquery();
				_fsp--;

				adaptor.addChild(root_0, q.getTree());
				retval.query = q.query;

			}
				break;
			case 2:
				// Cql.g3:45:7: c= scopedClause
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_scopedClause_in_cqlquery130);
				c = scopedClause();
				_fsp--;

				adaptor.addChild(root_0, c.getTree());
				retval.query = new CqlQuery(c.clause);

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end cqlquery

	public static class qscope_return extends ParserRuleReturnScope {
		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start qscope
	// Cql.g3:47:1: qscope : ( '>' prefix '=' uri | '>' uri );
	public final qscope_return qscope() throws RecognitionException {
		qscope_return retval = new qscope_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token char_literal2 = null;
		Token char_literal4 = null;
		Token char_literal6 = null;
		prefix_return prefix3 = null;

		uri_return uri5 = null;

		uri_return uri7 = null;

		CommonTree char_literal2_tree = null;
		CommonTree char_literal4_tree = null;
		CommonTree char_literal6_tree = null;

		try {
			// Cql.g3:49:9: ( '>' prefix '=' uri | '>' uri )
			int alt2 = 2;
			int LA2_0 = input.LA(1);

			if ((LA2_0 == 13)) {
				switch (input.LA(2)) {
				case IDENTIFIER: {
					int LA2_2 = input.LA(3);

					if ((LA2_2 == 14)) {
						alt2 = 1;
					} else if (((LA2_2 >= AND && LA2_2 <= PROX)
							|| (LA2_2 >= IDENTIFIER && LA2_2 <= STRING)
							|| LA2_2 == 13 || LA2_2 == 16)) {
						alt2 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"47:1: qscope : ( '>' prefix '=' uri | '>' uri );",
								2, 2, input);

						throw nvae;
					}
				}
					break;
				case STRING: {
					int LA2_3 = input.LA(3);

					if ((LA2_3 == 14)) {
						alt2 = 1;
					} else if (((LA2_3 >= AND && LA2_3 <= PROX)
							|| (LA2_3 >= IDENTIFIER && LA2_3 <= STRING)
							|| LA2_3 == 13 || LA2_3 == 16)) {
						alt2 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"47:1: qscope : ( '>' prefix '=' uri | '>' uri );",
								2, 3, input);

						throw nvae;
					}
				}
					break;
				case AND: {
					int LA2_4 = input.LA(3);

					if ((LA2_4 == 14)) {
						alt2 = 1;
					} else if (((LA2_4 >= AND && LA2_4 <= PROX)
							|| (LA2_4 >= IDENTIFIER && LA2_4 <= STRING)
							|| LA2_4 == 13 || LA2_4 == 16)) {
						alt2 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"47:1: qscope : ( '>' prefix '=' uri | '>' uri );",
								2, 4, input);

						throw nvae;
					}
				}
					break;
				case OR: {
					int LA2_5 = input.LA(3);

					if ((LA2_5 == 14)) {
						alt2 = 1;
					} else if (((LA2_5 >= AND && LA2_5 <= PROX)
							|| (LA2_5 >= IDENTIFIER && LA2_5 <= STRING)
							|| LA2_5 == 13 || LA2_5 == 16)) {
						alt2 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"47:1: qscope : ( '>' prefix '=' uri | '>' uri );",
								2, 5, input);

						throw nvae;
					}
				}
					break;
				case NOT: {
					int LA2_6 = input.LA(3);

					if ((LA2_6 == 14)) {
						alt2 = 1;
					} else if (((LA2_6 >= AND && LA2_6 <= PROX)
							|| (LA2_6 >= IDENTIFIER && LA2_6 <= STRING)
							|| LA2_6 == 13 || LA2_6 == 16)) {
						alt2 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"47:1: qscope : ( '>' prefix '=' uri | '>' uri );",
								2, 6, input);

						throw nvae;
					}
				}
					break;
				case PROX: {
					int LA2_7 = input.LA(3);

					if (((LA2_7 >= AND && LA2_7 <= PROX)
							|| (LA2_7 >= IDENTIFIER && LA2_7 <= STRING)
							|| LA2_7 == 13 || LA2_7 == 16)) {
						alt2 = 2;
					} else if ((LA2_7 == 14)) {
						alt2 = 1;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"47:1: qscope : ( '>' prefix '=' uri | '>' uri );",
								2, 7, input);

						throw nvae;
					}
				}
					break;
				default:
					NoViableAltException nvae = new NoViableAltException(
							"47:1: qscope : ( '>' prefix '=' uri | '>' uri );",
							2, 1, input);

					throw nvae;
				}

			} else {
				NoViableAltException nvae = new NoViableAltException(
						"47:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2,
						0, input);

				throw nvae;
			}
			switch (alt2) {
			case 1:
				// Cql.g3:49:11: '>' prefix '=' uri
			{
				root_0 = (CommonTree) adaptor.nil();

				char_literal2 = (Token) input.LT(1);
				match(input, 13, FOLLOW_13_in_qscope146);
				char_literal2_tree = (CommonTree) adaptor.create(char_literal2);
				adaptor.addChild(root_0, char_literal2_tree);

				pushFollow(FOLLOW_prefix_in_qscope148);
				prefix3 = prefix();
				_fsp--;

				adaptor.addChild(root_0, prefix3.getTree());
				char_literal4 = (Token) input.LT(1);
				match(input, 14, FOLLOW_14_in_qscope150);
				char_literal4_tree = (CommonTree) adaptor.create(char_literal4);
				adaptor.addChild(root_0, char_literal4_tree);

				pushFollow(FOLLOW_uri_in_qscope152);
				uri5 = uri();
				_fsp--;

				adaptor.addChild(root_0, uri5.getTree());

			}
				break;
			case 2:
				// Cql.g3:49:32: '>' uri
			{
				root_0 = (CommonTree) adaptor.nil();

				char_literal6 = (Token) input.LT(1);
				match(input, 13, FOLLOW_13_in_qscope156);
				char_literal6_tree = (CommonTree) adaptor.create(char_literal6);
				adaptor.addChild(root_0, char_literal6_tree);

				pushFollow(FOLLOW_uri_in_qscope158);
				uri7 = uri();
				_fsp--;

				adaptor.addChild(root_0, uri7.getTree());

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end qscope

	public static class prefix_return extends ParserRuleReturnScope {
		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start prefix
	// Cql.g3:50:1: prefix : term ;
	public final prefix_return prefix() throws RecognitionException {
		prefix_return retval = new prefix_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		term_return term8 = null;

		try {
			// Cql.g3:50:9: ( term )
			// Cql.g3:50:11: term
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_term_in_prefix167);
				term8 = term();
				_fsp--;

				adaptor.addChild(root_0, term8.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end prefix

	public static class uri_return extends ParserRuleReturnScope {
		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start uri
	// Cql.g3:51:1: uri : term ;
	public final uri_return uri() throws RecognitionException {
		uri_return retval = new uri_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		term_return term9 = null;

		try {
			// Cql.g3:51:7: ( term )
			// Cql.g3:51:9: term
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_term_in_uri177);
				term9 = term();
				_fsp--;

				adaptor.addChild(root_0, term9.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end uri

	public static class scopedClause_return extends ParserRuleReturnScope {
		public CqlClause clause;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start scopedClause
	// Cql.g3:52:1: scopedClause returns [CqlClause clause] : left= searchClause
	// (op= booleanGroup right= searchClause )* ;
	public final scopedClause_return scopedClause() throws RecognitionException {
		scopedClause_return retval = new scopedClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		searchClause_return left = null;

		booleanGroup_return op = null;

		searchClause_return right = null;

		try {
			// Cql.g3:55:41: (left= searchClause (op= booleanGroup right=
			// searchClause )* )
			// Cql.g3:56:3: left= searchClause (op= booleanGroup right=
			// searchClause )*
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_searchClause_in_scopedClause197);
				left = searchClause();
				_fsp--;

				adaptor.addChild(root_0, left.getTree());
				retval.clause = left.clause;
				// Cql.g3:57:3: (op= booleanGroup right= searchClause )*
				loop3: do {
					int alt3 = 2;
					int LA3_0 = input.LA(1);

					if (((LA3_0 >= AND && LA3_0 <= PROX))) {
						alt3 = 1;
					}

					switch (alt3) {
					case 1:
						// Cql.g3:57:4: op= booleanGroup right= searchClause
					{
						pushFollow(FOLLOW_booleanGroup_in_scopedClause206);
						op = booleanGroup();
						_fsp--;

						root_0 = (CommonTree) adaptor.becomeRoot(op.getTree(),
								root_0);
						pushFollow(FOLLOW_searchClause_in_scopedClause211);
						right = searchClause();
						_fsp--;

						adaptor.addChild(root_0, right.getTree());
						retval.clause = new CqlBoolean(retval.clause, op.value,
								right.clause);

					}
						break;

					default:
						break loop3;
					}
				} while (true);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end scopedClause

	public static class booleanGroup_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start booleanGroup
	// Cql.g3:62:1: booleanGroup returns [String value] : b= bool ( modifierList
	// )? ;
	public final booleanGroup_return booleanGroup() throws RecognitionException {
		booleanGroup_return retval = new booleanGroup_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		bool_return b = null;

		modifierList_return modifierList10 = null;

		try {
			// Cql.g3:62:37: (b= bool ( modifierList )? )
			// Cql.g3:63:2: b= bool ( modifierList )?
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_bool_in_booleanGroup239);
				b = bool();
				_fsp--;

				adaptor.addChild(root_0, b.getTree());
				// Cql.g3:63:9: ( modifierList )?
				int alt4 = 2;
				int LA4_0 = input.LA(1);

				if ((LA4_0 == 15)) {
					alt4 = 1;
				}
				switch (alt4) {
				case 1:
					// Cql.g3:63:10: modifierList
				{
					pushFollow(FOLLOW_modifierList_in_booleanGroup242);
					modifierList10 = modifierList();
					_fsp--;

					adaptor.addChild(root_0, modifierList10.getTree());

				}
					break;

				}

				retval.value = b.value;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end booleanGroup

	public static class bool_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start bool
	// Cql.g3:64:1: bool returns [String value] : ( AND | OR | NOT | PROX );
	public final bool_return bool() throws RecognitionException {
		bool_return retval = new bool_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token AND11 = null;
		Token OR12 = null;
		Token NOT13 = null;
		Token PROX14 = null;

		CommonTree AND11_tree = null;
		CommonTree OR12_tree = null;
		CommonTree NOT13_tree = null;
		CommonTree PROX14_tree = null;

		try {
			// Cql.g3:65:2: ( AND | OR | NOT | PROX )
			int alt5 = 4;
			switch (input.LA(1)) {
			case AND: {
				alt5 = 1;
			}
				break;
			case OR: {
				alt5 = 2;
			}
				break;
			case NOT: {
				alt5 = 3;
			}
				break;
			case PROX: {
				alt5 = 4;
			}
				break;
			default:
				NoViableAltException nvae = new NoViableAltException(
						"64:1: bool returns [String value] : ( AND | OR | NOT | PROX );",
						5, 0, input);

				throw nvae;
			}

			switch (alt5) {
			case 1:
				// Cql.g3:65:4: AND
			{
				root_0 = (CommonTree) adaptor.nil();

				AND11 = (Token) input.LT(1);
				match(input, AND, FOLLOW_AND_in_bool259);
				AND11_tree = (CommonTree) adaptor.create(AND11);
				adaptor.addChild(root_0, AND11_tree);

				retval.value = "and";

			}
				break;
			case 2:
				// Cql.g3:66:4: OR
			{
				root_0 = (CommonTree) adaptor.nil();

				OR12 = (Token) input.LT(1);
				match(input, OR, FOLLOW_OR_in_bool266);
				OR12_tree = (CommonTree) adaptor.create(OR12);
				adaptor.addChild(root_0, OR12_tree);

				retval.value = "or";

			}
				break;
			case 3:
				// Cql.g3:67:4: NOT
			{
				root_0 = (CommonTree) adaptor.nil();

				NOT13 = (Token) input.LT(1);
				match(input, NOT, FOLLOW_NOT_in_bool273);
				NOT13_tree = (CommonTree) adaptor.create(NOT13);
				adaptor.addChild(root_0, NOT13_tree);

				retval.value = "not";

			}
				break;
			case 4:
				// Cql.g3:68:4: PROX
			{
				root_0 = (CommonTree) adaptor.nil();

				PROX14 = (Token) input.LT(1);
				match(input, PROX, FOLLOW_PROX_in_bool280);
				PROX14_tree = (CommonTree) adaptor.create(PROX14);
				adaptor.addChild(root_0, PROX14_tree);

				retval.value = "prox";

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end bool

	public static class modifierList_return extends ParserRuleReturnScope {
		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start modifierList
	// Cql.g3:70:1: modifierList : ( modifier )+ ;
	public final modifierList_return modifierList() throws RecognitionException {
		modifierList_return retval = new modifierList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		modifier_return modifier15 = null;

		try {
			// Cql.g3:72:14: ( ( modifier )+ )
			// Cql.g3:72:16: ( modifier )+
			{
				root_0 = (CommonTree) adaptor.nil();

				// Cql.g3:72:16: ( modifier )+
				int cnt6 = 0;
				loop6: do {
					int alt6 = 2;
					int LA6_0 = input.LA(1);

					if ((LA6_0 == 15)) {
						alt6 = 1;
					}

					switch (alt6) {
					case 1:
						// Cql.g3:72:17: modifier
					{
						pushFollow(FOLLOW_modifier_in_modifierList296);
						modifier15 = modifier();
						_fsp--;

						adaptor.addChild(root_0, modifier15.getTree());

					}
						break;

					default:
						if (cnt6 >= 1)
							break loop6;
						EarlyExitException eee = new EarlyExitException(6,
								input);
						throw eee;
					}
					cnt6++;
				} while (true);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end modifierList

	public static class modifier_return extends ParserRuleReturnScope {
		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start modifier
	// Cql.g3:73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue
	// | '/' modifierName );
	public final modifier_return modifier() throws RecognitionException {
		modifier_return retval = new modifier_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token char_literal16 = null;
		Token char_literal20 = null;
		modifierName_return modifierName17 = null;

		comparitorSymbol_return comparitorSymbol18 = null;

		modifierValue_return modifierValue19 = null;

		modifierName_return modifierName21 = null;

		CommonTree char_literal16_tree = null;
		CommonTree char_literal20_tree = null;

		try {
			// Cql.g3:73:11: ( '/' modifierName comparitorSymbol modifierValue |
			// '/' modifierName )
			int alt7 = 2;
			int LA7_0 = input.LA(1);

			if ((LA7_0 == 15)) {
				switch (input.LA(2)) {
				case IDENTIFIER: {
					int LA7_2 = input.LA(3);

					if (((LA7_2 >= 13 && LA7_2 <= 14) || (LA7_2 >= 18 && LA7_2 <= 21))) {
						alt7 = 1;
					} else if (((LA7_2 >= AND && LA7_2 <= PROX)
							|| (LA7_2 >= IDENTIFIER && LA7_2 <= STRING) || (LA7_2 >= 15 && LA7_2 <= 16))) {
						alt7 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
								7, 2, input);

						throw nvae;
					}
				}
					break;
				case STRING: {
					int LA7_3 = input.LA(3);

					if (((LA7_3 >= 13 && LA7_3 <= 14) || (LA7_3 >= 18 && LA7_3 <= 21))) {
						alt7 = 1;
					} else if (((LA7_3 >= AND && LA7_3 <= PROX)
							|| (LA7_3 >= IDENTIFIER && LA7_3 <= STRING) || (LA7_3 >= 15 && LA7_3 <= 16))) {
						alt7 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
								7, 3, input);

						throw nvae;
					}
				}
					break;
				case AND: {
					int LA7_4 = input.LA(3);

					if (((LA7_4 >= 13 && LA7_4 <= 14) || (LA7_4 >= 18 && LA7_4 <= 21))) {
						alt7 = 1;
					} else if (((LA7_4 >= AND && LA7_4 <= PROX)
							|| (LA7_4 >= IDENTIFIER && LA7_4 <= STRING) || (LA7_4 >= 15 && LA7_4 <= 16))) {
						alt7 = 2;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
								7, 4, input);

						throw nvae;
					}
				}
					break;
				case OR: {
					int LA7_5 = input.LA(3);

					if (((LA7_5 >= AND && LA7_5 <= PROX)
							|| (LA7_5 >= IDENTIFIER && LA7_5 <= STRING) || (LA7_5 >= 15 && LA7_5 <= 16))) {
						alt7 = 2;
					} else if (((LA7_5 >= 13 && LA7_5 <= 14) || (LA7_5 >= 18 && LA7_5 <= 21))) {
						alt7 = 1;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
								7, 5, input);

						throw nvae;
					}
				}
					break;
				case NOT: {
					int LA7_6 = input.LA(3);

					if (((LA7_6 >= AND && LA7_6 <= PROX)
							|| (LA7_6 >= IDENTIFIER && LA7_6 <= STRING) || (LA7_6 >= 15 && LA7_6 <= 16))) {
						alt7 = 2;
					} else if (((LA7_6 >= 13 && LA7_6 <= 14) || (LA7_6 >= 18 && LA7_6 <= 21))) {
						alt7 = 1;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
								7, 6, input);

						throw nvae;
					}
				}
					break;
				case PROX: {
					int LA7_7 = input.LA(3);

					if (((LA7_7 >= AND && LA7_7 <= PROX)
							|| (LA7_7 >= IDENTIFIER && LA7_7 <= STRING) || (LA7_7 >= 15 && LA7_7 <= 16))) {
						alt7 = 2;
					} else if (((LA7_7 >= 13 && LA7_7 <= 14) || (LA7_7 >= 18 && LA7_7 <= 21))) {
						alt7 = 1;
					} else {
						NoViableAltException nvae = new NoViableAltException(
								"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
								7, 7, input);

						throw nvae;
					}
				}
					break;
				default:
					NoViableAltException nvae = new NoViableAltException(
							"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
							7, 1, input);

					throw nvae;
				}

			} else {
				NoViableAltException nvae = new NoViableAltException(
						"73:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );",
						7, 0, input);

				throw nvae;
			}
			switch (alt7) {
			case 1:
				// Cql.g3:73:13: '/' modifierName comparitorSymbol modifierValue
			{
				root_0 = (CommonTree) adaptor.nil();

				char_literal16 = (Token) input.LT(1);
				match(input, 15, FOLLOW_15_in_modifier307);
				char_literal16_tree = (CommonTree) adaptor
						.create(char_literal16);
				adaptor.addChild(root_0, char_literal16_tree);

				pushFollow(FOLLOW_modifierName_in_modifier309);
				modifierName17 = modifierName();
				_fsp--;

				adaptor.addChild(root_0, modifierName17.getTree());
				pushFollow(FOLLOW_comparitorSymbol_in_modifier311);
				comparitorSymbol18 = comparitorSymbol();
				_fsp--;

				adaptor.addChild(root_0, comparitorSymbol18.getTree());
				pushFollow(FOLLOW_modifierValue_in_modifier313);
				modifierValue19 = modifierValue();
				_fsp--;

				adaptor.addChild(root_0, modifierValue19.getTree());

			}
				break;
			case 2:
				// Cql.g3:74:9: '/' modifierName
			{
				root_0 = (CommonTree) adaptor.nil();

				char_literal20 = (Token) input.LT(1);
				match(input, 15, FOLLOW_15_in_modifier323);
				char_literal20_tree = (CommonTree) adaptor
						.create(char_literal20);
				adaptor.addChild(root_0, char_literal20_tree);

				pushFollow(FOLLOW_modifierName_in_modifier325);
				modifierName21 = modifierName();
				_fsp--;

				adaptor.addChild(root_0, modifierName21.getTree());

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end modifier

	public static class modifierName_return extends ParserRuleReturnScope {
		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start modifierName
	// Cql.g3:75:1: modifierName : term ;
	public final modifierName_return modifierName() throws RecognitionException {
		modifierName_return retval = new modifierName_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		term_return term22 = null;

		try {
			// Cql.g3:75:14: ( term )
			// Cql.g3:75:16: term
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_term_in_modifierName333);
				term22 = term();
				_fsp--;

				adaptor.addChild(root_0, term22.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end modifierName

	public static class modifierValue_return extends ParserRuleReturnScope {
		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start modifierValue
	// Cql.g3:76:1: modifierValue : term ;
	public final modifierValue_return modifierValue()
			throws RecognitionException {
		modifierValue_return retval = new modifierValue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		term_return term23 = null;

		try {
			// Cql.g3:76:15: ( term )
			// Cql.g3:76:17: term
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_term_in_modifierValue341);
				term23 = term();
				_fsp--;

				adaptor.addChild(root_0, term23.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end modifierValue

	public static class searchClause_return extends ParserRuleReturnScope {
		public CqlClause clause;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start searchClause
	// Cql.g3:77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery
	// ')' | i= index r= relation v= searchTerm | t= searchTerm );
	public final searchClause_return searchClause() throws RecognitionException {
		searchClause_return retval = new searchClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		cqlquery_return q = null;

		index_return i = null;

		relation_return r = null;

		searchTerm_return v = null;

		searchTerm_return t = null;

		try {
			// Cql.g3:81:6: ( '(' q= cqlquery ')' | i= index r= relation v=
			// searchTerm | t= searchTerm )
			int alt8 = 3;
			switch (input.LA(1)) {
			case 16: {
				alt8 = 1;
			}
				break;
			case IDENTIFIER: {
				int LA8_2 = input.LA(2);

				if ((LA8_2 == WITHIN || (LA8_2 >= 13 && LA8_2 <= 14) || (LA8_2 >= 18 && LA8_2 <= 21))) {
					alt8 = 2;
				} else if ((LA8_2 == EOF || (LA8_2 >= AND && LA8_2 <= PROX) || LA8_2 == 17)) {
					alt8 = 3;
				} else {
					NoViableAltException nvae = new NoViableAltException(
							"77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );",
							8, 2, input);

					throw nvae;
				}
			}
				break;
			case STRING: {
				int LA8_3 = input.LA(2);

				if ((LA8_3 == WITHIN || (LA8_3 >= 13 && LA8_3 <= 14) || (LA8_3 >= 18 && LA8_3 <= 21))) {
					alt8 = 2;
				} else if ((LA8_3 == EOF || (LA8_3 >= AND && LA8_3 <= PROX) || LA8_3 == 17)) {
					alt8 = 3;
				} else {
					NoViableAltException nvae = new NoViableAltException(
							"77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );",
							8, 3, input);

					throw nvae;
				}
			}
				break;
			case AND: {
				int LA8_4 = input.LA(2);

				if ((LA8_4 == EOF || (LA8_4 >= AND && LA8_4 <= PROX) || LA8_4 == 17)) {
					alt8 = 3;
				} else if ((LA8_4 == WITHIN || (LA8_4 >= 13 && LA8_4 <= 14) || (LA8_4 >= 18 && LA8_4 <= 21))) {
					alt8 = 2;
				} else {
					NoViableAltException nvae = new NoViableAltException(
							"77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );",
							8, 4, input);

					throw nvae;
				}
			}
				break;
			case OR: {
				int LA8_5 = input.LA(2);

				if ((LA8_5 == WITHIN || (LA8_5 >= 13 && LA8_5 <= 14) || (LA8_5 >= 18 && LA8_5 <= 21))) {
					alt8 = 2;
				} else if ((LA8_5 == EOF || (LA8_5 >= AND && LA8_5 <= PROX) || LA8_5 == 17)) {
					alt8 = 3;
				} else {
					NoViableAltException nvae = new NoViableAltException(
							"77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );",
							8, 5, input);

					throw nvae;
				}
			}
				break;
			case NOT: {
				int LA8_6 = input.LA(2);

				if ((LA8_6 == EOF || (LA8_6 >= AND && LA8_6 <= PROX) || LA8_6 == 17)) {
					alt8 = 3;
				} else if ((LA8_6 == WITHIN || (LA8_6 >= 13 && LA8_6 <= 14) || (LA8_6 >= 18 && LA8_6 <= 21))) {
					alt8 = 2;
				} else {
					NoViableAltException nvae = new NoViableAltException(
							"77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );",
							8, 6, input);

					throw nvae;
				}
			}
				break;
			case PROX: {
				int LA8_7 = input.LA(2);

				if ((LA8_7 == EOF || (LA8_7 >= AND && LA8_7 <= PROX) || LA8_7 == 17)) {
					alt8 = 3;
				} else if ((LA8_7 == WITHIN || (LA8_7 >= 13 && LA8_7 <= 14) || (LA8_7 >= 18 && LA8_7 <= 21))) {
					alt8 = 2;
				} else {
					NoViableAltException nvae = new NoViableAltException(
							"77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );",
							8, 7, input);

					throw nvae;
				}
			}
				break;
			default:
				NoViableAltException nvae = new NoViableAltException(
						"77:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );",
						8, 0, input);

				throw nvae;
			}

			switch (alt8) {
			case 1:
				// Cql.g3:81:8: '(' q= cqlquery ')'
			{
				root_0 = (CommonTree) adaptor.nil();

				input.LT(1);
				match(input, 16, FOLLOW_16_in_searchClause362);
				pushFollow(FOLLOW_cqlquery_in_searchClause367);
				q = cqlquery();
				_fsp--;

				adaptor.addChild(root_0, q.getTree());
				input.LT(1);
				match(input, 17, FOLLOW_17_in_searchClause369);
				retval.clause = q.query.root;

			}
				break;
			case 2:
				// Cql.g3:82:8: i= index r= relation v= searchTerm
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_index_in_searchClause383);
				i = index();
				_fsp--;

				adaptor.addChild(root_0, i.getTree());
				pushFollow(FOLLOW_relation_in_searchClause387);
				r = relation();
				_fsp--;

				root_0 = (CommonTree) adaptor.becomeRoot(r.getTree(), root_0);
				pushFollow(FOLLOW_searchTerm_in_searchClause392);
				v = searchTerm();
				_fsp--;

				adaptor.addChild(root_0, v.getTree());
				retval.clause = new CqlRelation(i.value, r.value, v.value);

			}
				break;
			case 3:
				// Cql.g3:84:8: t= searchTerm
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_searchTerm_in_searchClause411);
				t = searchTerm();
				_fsp--;

				adaptor.addChild(root_0, t.getTree());
				retval.clause = new CqlTerm(t.value);

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end searchClause

	public static class index_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start index
	// Cql.g3:86:1: index returns [String value] : t= term ;
	public final index_return index() throws RecognitionException {
		index_return retval = new index_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		term_return t = null;

		try {
			// Cql.g3:86:31: (t= term )
			// Cql.g3:86:33: t= term
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_term_in_index429);
				t = term();
				_fsp--;

				adaptor.addChild(root_0, t.getTree());
				retval.value = t.value;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end index

	public static class relation_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start relation
	// Cql.g3:88:1: relation returns [String value] : c= comparitor (
	// modifierList )? ;
	public final relation_return relation() throws RecognitionException {
		relation_return retval = new relation_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		comparitor_return c = null;

		modifierList_return modifierList26 = null;

		try {
			// Cql.g3:88:33: (c= comparitor ( modifierList )? )
			// Cql.g3:89:7: c= comparitor ( modifierList )?
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_comparitor_in_relation453);
				c = comparitor();
				_fsp--;

				adaptor.addChild(root_0, c.getTree());
				retval.value = c.value;
				// Cql.g3:89:42: ( modifierList )?
				int alt9 = 2;
				int LA9_0 = input.LA(1);

				if ((LA9_0 == 15)) {
					alt9 = 1;
				}
				switch (alt9) {
				case 1:
					// Cql.g3:89:43: modifierList
				{
					pushFollow(FOLLOW_modifierList_in_relation458);
					modifierList26 = modifierList();
					_fsp--;

					adaptor.addChild(root_0, modifierList26.getTree());

				}
					break;

				}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end relation

	public static class comparitor_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start comparitor
	// Cql.g3:90:1: comparitor returns [String value] : (s= comparitorSymbol |
	// n= namedComparitor );
	public final comparitor_return comparitor() throws RecognitionException {
		comparitor_return retval = new comparitor_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		comparitorSymbol_return s = null;

		namedComparitor_return n = null;

		try {
			// Cql.g3:91:5: (s= comparitorSymbol | n= namedComparitor )
			int alt10 = 2;
			int LA10_0 = input.LA(1);

			if (((LA10_0 >= 13 && LA10_0 <= 14) || (LA10_0 >= 18 && LA10_0 <= 21))) {
				alt10 = 1;
			} else if ((LA10_0 == WITHIN)) {
				alt10 = 2;
			} else {
				NoViableAltException nvae = new NoViableAltException(
						"90:1: comparitor returns [String value] : (s= comparitorSymbol | n= namedComparitor );",
						10, 0, input);

				throw nvae;
			}
			switch (alt10) {
			case 1:
				// Cql.g3:91:7: s= comparitorSymbol
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_comparitorSymbol_in_comparitor478);
				s = comparitorSymbol();
				_fsp--;

				adaptor.addChild(root_0, s.getTree());
				retval.value = s.value;

			}
				break;
			case 2:
				// Cql.g3:92:7: n= namedComparitor
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_namedComparitor_in_comparitor490);
				n = namedComparitor();
				_fsp--;

				adaptor.addChild(root_0, n.getTree());
				retval.value = n.value;

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end comparitor

	public static class comparitorSymbol_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start comparitorSymbol
	// Cql.g3:93:1: comparitorSymbol returns [String value] : ( '=' | '>' | '<'
	// | '>=' | '<=' | '<>' );
	public final comparitorSymbol_return comparitorSymbol()
			throws RecognitionException {
		comparitorSymbol_return retval = new comparitorSymbol_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token char_literal27 = null;
		Token char_literal28 = null;
		Token char_literal29 = null;
		Token string_literal30 = null;
		Token string_literal31 = null;
		Token string_literal32 = null;

		CommonTree char_literal27_tree = null;
		CommonTree char_literal28_tree = null;
		CommonTree char_literal29_tree = null;
		CommonTree string_literal30_tree = null;
		CommonTree string_literal31_tree = null;
		CommonTree string_literal32_tree = null;

		try {
			// Cql.g3:94:7: ( '=' | '>' | '<' | '>=' | '<=' | '<>' )
			int alt11 = 6;
			switch (input.LA(1)) {
			case 14: {
				alt11 = 1;
			}
				break;
			case 13: {
				alt11 = 2;
			}
				break;
			case 18: {
				alt11 = 3;
			}
				break;
			case 19: {
				alt11 = 4;
			}
				break;
			case 20: {
				alt11 = 5;
			}
				break;
			case 21: {
				alt11 = 6;
			}
				break;
			default:
				NoViableAltException nvae = new NoViableAltException(
						"93:1: comparitorSymbol returns [String value] : ( '=' | '>' | '<' | '>=' | '<=' | '<>' );",
						11, 0, input);

				throw nvae;
			}

			switch (alt11) {
			case 1:
				// Cql.g3:94:9: '='
			{
				root_0 = (CommonTree) adaptor.nil();

				char_literal27 = (Token) input.LT(1);
				match(input, 14, FOLLOW_14_in_comparitorSymbol510);
				char_literal27_tree = (CommonTree) adaptor
						.create(char_literal27);
				adaptor.addChild(root_0, char_literal27_tree);

				retval.value = "=";

			}
				break;
			case 2:
				// Cql.g3:95:9: '>'
			{
				root_0 = (CommonTree) adaptor.nil();

				char_literal28 = (Token) input.LT(1);
				match(input, 13, FOLLOW_13_in_comparitorSymbol522);
				char_literal28_tree = (CommonTree) adaptor
						.create(char_literal28);
				adaptor.addChild(root_0, char_literal28_tree);

				retval.value = ">";

			}
				break;
			case 3:
				// Cql.g3:96:9: '<'
			{
				root_0 = (CommonTree) adaptor.nil();

				char_literal29 = (Token) input.LT(1);
				match(input, 18, FOLLOW_18_in_comparitorSymbol534);
				char_literal29_tree = (CommonTree) adaptor
						.create(char_literal29);
				adaptor.addChild(root_0, char_literal29_tree);

				retval.value = "<";

			}
				break;
			case 4:
				// Cql.g3:97:9: '>='
			{
				root_0 = (CommonTree) adaptor.nil();

				string_literal30 = (Token) input.LT(1);
				match(input, 19, FOLLOW_19_in_comparitorSymbol546);
				string_literal30_tree = (CommonTree) adaptor
						.create(string_literal30);
				adaptor.addChild(root_0, string_literal30_tree);

				retval.value = ">=";

			}
				break;
			case 5:
				// Cql.g3:98:9: '<='
			{
				root_0 = (CommonTree) adaptor.nil();

				string_literal31 = (Token) input.LT(1);
				match(input, 20, FOLLOW_20_in_comparitorSymbol558);
				string_literal31_tree = (CommonTree) adaptor
						.create(string_literal31);
				adaptor.addChild(root_0, string_literal31_tree);

				retval.value = "<=";

			}
				break;
			case 6:
				// Cql.g3:99:9: '<>'
			{
				root_0 = (CommonTree) adaptor.nil();

				string_literal32 = (Token) input.LT(1);
				match(input, 21, FOLLOW_21_in_comparitorSymbol570);
				string_literal32_tree = (CommonTree) adaptor
						.create(string_literal32);
				adaptor.addChild(root_0, string_literal32_tree);

				retval.value = "<>";

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end comparitorSymbol

	public static class namedComparitor_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start namedComparitor
	// Cql.g3:101:1: namedComparitor returns [String value] : WITHIN ;
	public final namedComparitor_return namedComparitor()
			throws RecognitionException {
		namedComparitor_return retval = new namedComparitor_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WITHIN33 = null;

		CommonTree WITHIN33_tree = null;

		try {
			// Cql.g3:101:41: ( WITHIN )
			// Cql.g3:102:7: WITHIN
			{
				root_0 = (CommonTree) adaptor.nil();

				WITHIN33 = (Token) input.LT(1);
				match(input, WITHIN, FOLLOW_WITHIN_in_namedComparitor593);
				WITHIN33_tree = (CommonTree) adaptor.create(WITHIN33);
				adaptor.addChild(root_0, WITHIN33_tree);

				retval.value = "within";

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end namedComparitor

	public static class searchTerm_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start searchTerm
	// Cql.g3:105:1: searchTerm returns [String value] : t= term ;
	public final searchTerm_return searchTerm() throws RecognitionException {
		searchTerm_return retval = new searchTerm_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		term_return t = null;

		try {
			// Cql.g3:105:36: (t= term )
			// Cql.g3:105:38: t= term
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_term_in_searchTerm612);
				t = term();
				_fsp--;

				adaptor.addChild(root_0, t.getTree());
				retval.value = t.value;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end searchTerm

	public static class term_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start term
	// Cql.g3:107:1: term returns [String value] : (i= identifier | AND | OR |
	// NOT | PROX );
	public final term_return term() throws RecognitionException {
		term_return retval = new term_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token AND34 = null;
		Token OR35 = null;
		Token NOT36 = null;
		Token PROX37 = null;
		identifier_return i = null;

		CommonTree AND34_tree = null;
		CommonTree OR35_tree = null;
		CommonTree NOT36_tree = null;
		CommonTree PROX37_tree = null;

		try {
			// Cql.g3:107:30: (i= identifier | AND | OR | NOT | PROX )
			int alt12 = 5;
			switch (input.LA(1)) {
			case IDENTIFIER:
			case STRING: {
				alt12 = 1;
			}
				break;
			case AND: {
				alt12 = 2;
			}
				break;
			case OR: {
				alt12 = 3;
			}
				break;
			case NOT: {
				alt12 = 4;
			}
				break;
			case PROX: {
				alt12 = 5;
			}
				break;
			default:
				NoViableAltException nvae = new NoViableAltException(
						"107:1: term returns [String value] : (i= identifier | AND | OR | NOT | PROX );",
						12, 0, input);

				throw nvae;
			}

			switch (alt12) {
			case 1:
				// Cql.g3:108:5: i= identifier
			{
				root_0 = (CommonTree) adaptor.nil();

				pushFollow(FOLLOW_identifier_in_term634);
				i = identifier();
				_fsp--;

				adaptor.addChild(root_0, i.getTree());
				retval.value = i.value;

			}
				break;
			case 2:
				// Cql.g3:109:7: AND
			{
				root_0 = (CommonTree) adaptor.nil();

				AND34 = (Token) input.LT(1);
				match(input, AND, FOLLOW_AND_in_term644);
				AND34_tree = (CommonTree) adaptor.create(AND34);
				adaptor.addChild(root_0, AND34_tree);

				retval.value = "and";

			}
				break;
			case 3:
				// Cql.g3:110:7: OR
			{
				root_0 = (CommonTree) adaptor.nil();

				OR35 = (Token) input.LT(1);
				match(input, OR, FOLLOW_OR_in_term654);
				OR35_tree = (CommonTree) adaptor.create(OR35);
				adaptor.addChild(root_0, OR35_tree);

				retval.value = "or";

			}
				break;
			case 4:
				// Cql.g3:111:7: NOT
			{
				root_0 = (CommonTree) adaptor.nil();

				NOT36 = (Token) input.LT(1);
				match(input, NOT, FOLLOW_NOT_in_term664);
				NOT36_tree = (CommonTree) adaptor.create(NOT36);
				adaptor.addChild(root_0, NOT36_tree);

				retval.value = "not";

			}
				break;
			case 5:
				// Cql.g3:112:7: PROX
			{
				root_0 = (CommonTree) adaptor.nil();

				PROX37 = (Token) input.LT(1);
				match(input, PROX, FOLLOW_PROX_in_term674);
				PROX37_tree = (CommonTree) adaptor.create(PROX37);
				adaptor.addChild(root_0, PROX37_tree);

				retval.value = "prox";

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end term

	public static class identifier_return extends ParserRuleReturnScope {
		public String value;

		CommonTree tree;

		public Object getTree() {
			return tree;
		}
	};

	// $ANTLR start identifier
	// Cql.g3:113:1: identifier returns [String value] : ( IDENTIFIER | STRING
	// );
	public final identifier_return identifier() throws RecognitionException {
		identifier_return retval = new identifier_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token IDENTIFIER38 = null;
		Token STRING39 = null;

		CommonTree IDENTIFIER38_tree = null;
		CommonTree STRING39_tree = null;

		try {
			// Cql.g3:113:35: ( IDENTIFIER | STRING )
			int alt13 = 2;
			int LA13_0 = input.LA(1);

			if ((LA13_0 == IDENTIFIER)) {
				alt13 = 1;
			} else if ((LA13_0 == STRING)) {
				alt13 = 2;
			} else {
				NoViableAltException nvae = new NoViableAltException(
						"113:1: identifier returns [String value] : ( IDENTIFIER | STRING );",
						13, 0, input);

				throw nvae;
			}
			switch (alt13) {
			case 1:
				// Cql.g3:114:5: IDENTIFIER
			{
				root_0 = (CommonTree) adaptor.nil();

				IDENTIFIER38 = (Token) input.LT(1);
				match(input, IDENTIFIER, FOLLOW_IDENTIFIER_in_identifier692);
				IDENTIFIER38_tree = (CommonTree) adaptor.create(IDENTIFIER38);
				adaptor.addChild(root_0, IDENTIFIER38_tree);

				retval.value = IDENTIFIER38.getText();

			}
				break;
			case 2:
				// Cql.g3:115:7: STRING
			{
				root_0 = (CommonTree) adaptor.nil();

				STRING39 = (Token) input.LT(1);
				match(input, STRING, FOLLOW_STRING_in_identifier702);
				STRING39_tree = (CommonTree) adaptor.create(STRING39);
				adaptor.addChild(root_0, STRING39_tree);

				retval.value = STRING39.getText();

			}
				break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree) adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end identifier

	public static final BitSet FOLLOW_cqlquery_in_cql87 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_qscope_in_cqlquery113 = new BitSet(
			new long[] { 0x00000000000126F0L });

	public static final BitSet FOLLOW_cqlquery_in_cqlquery118 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_scopedClause_in_cqlquery130 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_13_in_qscope146 = new BitSet(
			new long[] { 0x00000000000006F0L });

	public static final BitSet FOLLOW_prefix_in_qscope148 = new BitSet(
			new long[] { 0x0000000000004000L });

	public static final BitSet FOLLOW_14_in_qscope150 = new BitSet(
			new long[] { 0x00000000000006F0L });

	public static final BitSet FOLLOW_uri_in_qscope152 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_13_in_qscope156 = new BitSet(
			new long[] { 0x00000000000006F0L });

	public static final BitSet FOLLOW_uri_in_qscope158 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_term_in_prefix167 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_term_in_uri177 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_searchClause_in_scopedClause197 = new BitSet(
			new long[] { 0x00000000000000F2L });

	public static final BitSet FOLLOW_booleanGroup_in_scopedClause206 = new BitSet(
			new long[] { 0x00000000000106F0L });

	public static final BitSet FOLLOW_searchClause_in_scopedClause211 = new BitSet(
			new long[] { 0x00000000000000F2L });

	public static final BitSet FOLLOW_bool_in_booleanGroup239 = new BitSet(
			new long[] { 0x0000000000008002L });

	public static final BitSet FOLLOW_modifierList_in_booleanGroup242 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_AND_in_bool259 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_OR_in_bool266 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_NOT_in_bool273 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_PROX_in_bool280 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_modifier_in_modifierList296 = new BitSet(
			new long[] { 0x0000000000008002L });

	public static final BitSet FOLLOW_15_in_modifier307 = new BitSet(
			new long[] { 0x00000000000006F0L });

	public static final BitSet FOLLOW_modifierName_in_modifier309 = new BitSet(
			new long[] { 0x00000000003C6000L });

	public static final BitSet FOLLOW_comparitorSymbol_in_modifier311 = new BitSet(
			new long[] { 0x00000000000006F0L });

	public static final BitSet FOLLOW_modifierValue_in_modifier313 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_15_in_modifier323 = new BitSet(
			new long[] { 0x00000000000006F0L });

	public static final BitSet FOLLOW_modifierName_in_modifier325 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_term_in_modifierName333 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_term_in_modifierValue341 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_16_in_searchClause362 = new BitSet(
			new long[] { 0x00000000000126F0L });

	public static final BitSet FOLLOW_cqlquery_in_searchClause367 = new BitSet(
			new long[] { 0x0000000000020000L });

	public static final BitSet FOLLOW_17_in_searchClause369 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_index_in_searchClause383 = new BitSet(
			new long[] { 0x00000000003C6100L });

	public static final BitSet FOLLOW_relation_in_searchClause387 = new BitSet(
			new long[] { 0x00000000000006F0L });

	public static final BitSet FOLLOW_searchTerm_in_searchClause392 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_searchTerm_in_searchClause411 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_term_in_index429 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_comparitor_in_relation453 = new BitSet(
			new long[] { 0x0000000000008002L });

	public static final BitSet FOLLOW_modifierList_in_relation458 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_comparitorSymbol_in_comparitor478 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_namedComparitor_in_comparitor490 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_14_in_comparitorSymbol510 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_13_in_comparitorSymbol522 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_18_in_comparitorSymbol534 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_19_in_comparitorSymbol546 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_20_in_comparitorSymbol558 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_21_in_comparitorSymbol570 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_WITHIN_in_namedComparitor593 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_term_in_searchTerm612 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_identifier_in_term634 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_AND_in_term644 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_OR_in_term654 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_NOT_in_term664 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_PROX_in_term674 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_IDENTIFIER_in_identifier692 = new BitSet(
			new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_STRING_in_identifier702 = new BitSet(
			new long[] { 0x0000000000000002L });

}