/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import eu.dnetlib.utils.RSClientNSContext;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPRUtils {
    private static final String REFERENCE_PARAMETER_NS = "http://www.driver.org";
    private static XPathExpression ADDRESS_EXPR = null;
    private static XPathExpression REFERENCE_PARAMETER_EXPR = null;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EPR createEPR(W3CEndpointReference w3cEpr) {
        try {
            StringWriter writer = new StringWriter();
            w3cEpr.writeTo((Result)new StreamResult(writer));
            EPR epr = new EPR();
            Node node = null;
            String address = null;
            Class<EPRUtils> clazz = EPRUtils.class;
            synchronized (EPRUtils.class) {
                node = (Node)REFERENCE_PARAMETER_EXPR.evaluate(new InputSource(new StringReader(writer.toString())), XPathConstants.NODE);
                address = ADDRESS_EXPR.evaluate(new InputSource(new StringReader(writer.toString())));
                // ** MonitorExit[var5_6] (shouldn't be in output)
                if (node != null && node.getChildNodes() != null) {
                    for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                        Node child = node.getChildNodes().item(i);
                        if (child.getNamespaceURI() == null || !child.getNamespaceURI().equals(REFERENCE_PARAMETER_NS)) continue;
                        String name = child.getLocalName();
                        String value = child.getTextContent();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found parameter " + name + ": " + value));
                        }
                        epr.setParameter(name, value);
                    }
                }
                epr.setAddress(address);
                epr.setEpr(writer.toString());
                return epr;
            }
        }
        catch (XPathExpressionException e) {
            logger.error((Object)"Error parsing epr", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static W3CEndpointReference createW3CEPR(EPR epr) {
        W3CEndpointReference w3cEpr = null;
        if (epr.getEpr() != null) {
            StringReader reader = new StringReader(epr.getEpr());
            w3cEpr = new W3CEndpointReference((Source)new StreamSource(reader));
        } else {
            StringWriter writer = new StringWriter();
            w3cEpr = EPRUtils.buildW3CEpr(epr);
            w3cEpr.writeTo((Result)new StreamResult(writer));
            epr.setEpr(writer.toString());
        }
        return w3cEpr;
    }

    public static W3CEndpointReference createW3CEPR(EndpointReferenceBuilder<Endpoint> builder, Endpoint endpoint) {
        W3CEndpointReference w3cepr = builder.getEndpointReference((Object)endpoint);
        return w3cepr;
    }

    public static EPR createEPR(EndpointReferenceBuilder<Endpoint> builder, Endpoint endpoint) {
        EPR epr = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating epr for " + endpoint.getImplementor().getClass()));
        }
        epr = EPRUtils.createEPR(EPRUtils.createW3CEPR(builder, endpoint));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created epr: " + epr));
        }
        return epr;
    }

    public static String eprToXml(EPR epr) {
        epr.setEpr(null);
        StringWriter xml = new StringWriter();
        EPRUtils.createW3CEPR(epr).writeTo((Result)new StreamResult(xml));
        return xml.toString();
    }

    public static EPR xmlToEpr(String xml) {
        return EPRUtils.createEPR((W3CEndpointReference)W3CEndpointReference.readFrom((Source)new StreamSource(new StringReader(xml))));
    }

    private static W3CEndpointReference buildW3CEpr(EPR epr) {
        try {
            W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            builder.address(epr.getAddress());
            builder.serviceName(new QName(REFERENCE_PARAMETER_NS, "serviceName"));
            for (String name : epr.getParameterNames()) {
                Element element = doc.createElementNS(REFERENCE_PARAMETER_NS, name);
                element.setTextContent(epr.getParameter(name));
                builder.referenceParameter(element);
            }
            return builder.build();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new RSClientNSContext());
        try {
            REFERENCE_PARAMETER_EXPR = xpath.compile("//wsa:ReferenceParameters");
            ADDRESS_EXPR = xpath.compile("//wsa:Address");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to build xpath expression.", e);
        }
        logger = Logger.getLogger(EPRUtils.class);
    }
}

