/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonFormat
extends Format {
    private static final long serialVersionUID = 1L;

    @Override
    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition position) {
        if (object == null) {
            toAppendTo.append("null");
        } else if (object instanceof Boolean) {
            toAppendTo.append(object);
        } else if (object instanceof List) {
            this.formatJsonArray((List)object, toAppendTo);
        } else if (object instanceof Number) {
            this.formatJsonNumber((Number)object, toAppendTo);
        } else if (object instanceof Map) {
            this.formatJsonObject((Map)object, toAppendTo);
        } else if (object instanceof String) {
            this.formatJsonString((String)object, toAppendTo);
        } else {
            throw new IllegalArgumentException();
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition position) {
        if (position.getIndex() >= source.length()) {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        if (source.startsWith("null", position.getIndex())) {
            position.setIndex(position.getIndex() + 4);
            return null;
        }
        if (source.startsWith("true", position.getIndex())) {
            position.setIndex(position.getIndex() + 4);
            return Boolean.TRUE;
        }
        if (source.startsWith("false", position.getIndex())) {
            position.setIndex(position.getIndex() + 5);
            return Boolean.FALSE;
        }
        int beginIndex = position.getIndex();
        Object value = null;
        switch (source.charAt(position.getIndex())) {
            case '[': {
                value = this.parseJsonArray(source, position);
                break;
            }
            case '{': {
                value = this.parseJsonObject(source, position);
                break;
            }
            case '\"': {
                value = this.parseJsonString(source, position);
                break;
            }
            default: {
                value = this.parseJsonNumber(source, position);
            }
        }
        if (position.getErrorIndex() != -1) {
            position.setIndex(beginIndex);
        }
        return value;
    }

    private void formatJsonArray(List<Object> array, StringBuffer toAppendTo) {
        toAppendTo.append('[');
        for (Object object : array) {
            this.format(object, toAppendTo, null);
            toAppendTo.append(',');
        }
        if (array.size() > 0) {
            toAppendTo.setLength(toAppendTo.length() - 1);
        }
        toAppendTo.append(']');
    }

    private void formatJsonNumber(Number number, StringBuffer toAppendTo) {
        toAppendTo.append(number);
    }

    private void formatJsonObject(Map<String, Object> object, StringBuffer toAppendTo) {
        toAppendTo.append('{');
        for (Map.Entry<String, Object> pair : object.entrySet()) {
            if (!(pair.getKey() instanceof String)) {
                throw new IllegalArgumentException();
            }
            this.formatJsonString(pair.getKey(), toAppendTo);
            toAppendTo.append(':');
            this.format(pair.getValue(), toAppendTo, null);
            toAppendTo.append(',');
        }
        if (object.size() > 0) {
            toAppendTo.setLength(toAppendTo.length() - 1);
        }
        toAppendTo.append('}');
    }

    private void formatJsonString(String string, StringBuffer toAppendTo) {
        toAppendTo.append('\"');
        block9: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    toAppendTo.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    toAppendTo.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    toAppendTo.append("\\b");
                    continue block9;
                }
                case '\f': {
                    toAppendTo.append("\\f");
                    continue block9;
                }
                case '\n': {
                    toAppendTo.append("\\n");
                    continue block9;
                }
                case '\r': {
                    toAppendTo.append("\\r");
                    continue block9;
                }
                case '\t': {
                    toAppendTo.append("\\t");
                    continue block9;
                }
                default: {
                    toAppendTo.append(string.charAt(i));
                }
            }
        }
        toAppendTo.append('\"');
    }

    private List<Object> parseJsonArray(String source, ParsePosition position) {
        if (position.getIndex() >= source.length() || source.charAt(position.getIndex()) != '[') {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        position.setIndex(position.getIndex() + 1);
        ArrayList<Object> array = new ArrayList<Object>();
        if (position.getIndex() < source.length() && source.charAt(position.getIndex()) != ']') {
            this.parseJsonElements(source, position, array);
            if (position.getErrorIndex() != -1) {
                return null;
            }
        }
        if (position.getIndex() >= source.length() || source.charAt(position.getIndex()) != ']') {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        position.setIndex(position.getIndex() + 1);
        return array;
    }

    private void parseJsonElements(String source, ParsePosition position, List<Object> elements) {
        Object value = this.parseObject(source, position);
        if (position.getErrorIndex() != -1) {
            return;
        }
        elements.add(value);
        if (position.getIndex() < source.length() && source.charAt(position.getIndex()) == ',') {
            position.setIndex(position.getIndex() + 1);
            this.parseJsonElements(source, position, elements);
            if (position.getErrorIndex() != -1) {
                return;
            }
        }
    }

    private Number parseJsonNumber(String source, ParsePosition position) {
        if (position.getIndex() >= source.length()) {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        return NumberFormat.getInstance().parse(source, position);
    }

    private Map<String, Object> parseJsonObject(String source, ParsePosition position) {
        if (position.getIndex() >= source.length() || source.charAt(position.getIndex()) != '{') {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        position.setIndex(position.getIndex() + 1);
        HashMap<String, Object> object = new HashMap<String, Object>();
        if (position.getIndex() < source.length() && source.charAt(position.getIndex()) != '}') {
            this.parseJsonMembers(source, position, object);
            if (position.getErrorIndex() != -1) {
                return null;
            }
        }
        if (position.getIndex() >= source.length() || source.charAt(position.getIndex()) != '}') {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        position.setIndex(position.getIndex() + 1);
        return object;
    }

    private void parseJsonMembers(String source, ParsePosition position, Map<String, Object> members) {
        JsonPair pair = this.parseJsonPair(source, position);
        if (position.getErrorIndex() != -1) {
            return;
        }
        members.put(pair.getName(), pair.getValue());
        if (position.getIndex() < source.length() && source.charAt(position.getIndex()) == ',') {
            position.setIndex(position.getIndex() + 1);
            this.parseJsonMembers(source, position, members);
            if (position.getErrorIndex() != -1) {
                return;
            }
        }
    }

    private JsonPair parseJsonPair(String source, ParsePosition position) {
        String name = this.parseJsonString(source, position);
        if (position.getErrorIndex() != -1) {
            return null;
        }
        if (position.getIndex() >= source.length() || source.charAt(position.getIndex()) != ':') {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        position.setIndex(position.getIndex() + 1);
        Object value = this.parseObject(source, position);
        if (position.getErrorIndex() != -1) {
            return null;
        }
        return new JsonPair(name, value);
    }

    private String parseJsonString(String source, ParsePosition position) {
        if (position.getIndex() >= source.length() || source.charAt(position.getIndex()) != '\"') {
            position.setErrorIndex(position.getIndex());
            return null;
        }
        StringBuilder string = new StringBuilder();
        block13: for (int i = position.getIndex() + 1; i < source.length(); ++i) {
            switch (source.charAt(i)) {
                case '\"': {
                    position.setIndex(i + 1);
                    return string.toString();
                }
                case '\\': {
                    if (++i == source.length()) {
                        position.setErrorIndex(i);
                        return null;
                    }
                    switch (source.charAt(i)) {
                        case '\"': {
                            string.append('\"');
                            continue block13;
                        }
                        case '\\': {
                            string.append('\\');
                            continue block13;
                        }
                        case 'b': {
                            string.append('\b');
                            continue block13;
                        }
                        case 'f': {
                            string.append('\f');
                            continue block13;
                        }
                        case 'n': {
                            string.append('\n');
                            continue block13;
                        }
                        case 'r': {
                            string.append('\n');
                            continue block13;
                        }
                        case 't': {
                            string.append('\t');
                            continue block13;
                        }
                    }
                    position.setErrorIndex(i);
                    return null;
                }
                default: {
                    string.append(source.charAt(i));
                }
            }
        }
        position.setErrorIndex(source.length());
        return null;
    }

    private class JsonPair {
        private final String name;
        private final Object value;

        public JsonPair(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

