/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils;

import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RFC3339DateFormat
extends DateFormat {
    private static final long serialVersionUID = 1L;
    private final NumberFormat twoDigits;
    private final NumberFormat threeDigits;
    private final NumberFormat fourDigits;
    private final Pattern pattern;

    public RFC3339DateFormat() {
        this.calendar = Calendar.getInstance();
        this.twoDigits = NumberFormat.getIntegerInstance();
        this.twoDigits.setGroupingUsed(false);
        this.twoDigits.setRoundingMode(RoundingMode.UNNECESSARY);
        this.twoDigits.setMaximumIntegerDigits(2);
        this.twoDigits.setMinimumIntegerDigits(2);
        this.threeDigits = NumberFormat.getIntegerInstance();
        this.threeDigits.setGroupingUsed(false);
        this.threeDigits.setRoundingMode(RoundingMode.UNNECESSARY);
        this.threeDigits.setMaximumIntegerDigits(3);
        this.threeDigits.setMinimumIntegerDigits(3);
        this.fourDigits = NumberFormat.getIntegerInstance();
        this.fourDigits.setGroupingUsed(false);
        this.fourDigits.setRoundingMode(RoundingMode.UNNECESSARY);
        this.fourDigits.setMaximumIntegerDigits(4);
        this.fourDigits.setMinimumIntegerDigits(4);
        this.pattern = Pattern.compile("^(\\d{4})\\-(\\d{2})\\-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})\\.(\\d{3})(Z|\\+(\\d{2}):(\\d{2})|\\-(\\d{2}):(\\d{2}))$");
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        int beginIndex = toAppendTo.length();
        toAppendTo.append(this.fourDigits.format(this.calendar.get(1)));
        toAppendTo.append("-");
        toAppendTo.append(this.twoDigits.format(this.calendar.get(2) + 1));
        toAppendTo.append("-");
        toAppendTo.append(this.twoDigits.format(this.calendar.get(5)));
        toAppendTo.append("T");
        toAppendTo.append(this.twoDigits.format(this.calendar.get(11)));
        toAppendTo.append(":");
        toAppendTo.append(this.twoDigits.format(this.calendar.get(12)));
        toAppendTo.append(":");
        toAppendTo.append(this.twoDigits.format(this.calendar.get(13)));
        toAppendTo.append(".");
        toAppendTo.append(this.threeDigits.format(this.calendar.get(14)));
        int offset = this.calendar.get(15) + this.calendar.get(16);
        if (offset == 0) {
            toAppendTo.append("Z");
        } else {
            toAppendTo.append(offset > 0 ? "+" : "-");
            toAppendTo.append(this.twoDigits.format(offset / 3600000));
            toAppendTo.append(":");
            toAppendTo.append(this.twoDigits.format(offset % 3600000 / 60000));
        }
        switch (fieldPosition.getField()) {
            case 1: {
                fieldPosition.setBeginIndex(beginIndex);
                fieldPosition.setEndIndex(beginIndex + 4);
                break;
            }
            case 2: {
                fieldPosition.setBeginIndex(beginIndex + 5);
                fieldPosition.setEndIndex(beginIndex + 7);
                break;
            }
            case 3: {
                fieldPosition.setBeginIndex(beginIndex + 8);
                fieldPosition.setEndIndex(beginIndex + 10);
                break;
            }
            case 5: {
                fieldPosition.setBeginIndex(beginIndex + 11);
                fieldPosition.setEndIndex(beginIndex + 13);
                break;
            }
            case 6: {
                fieldPosition.setBeginIndex(beginIndex + 14);
                fieldPosition.setEndIndex(beginIndex + 16);
                break;
            }
            case 7: {
                fieldPosition.setBeginIndex(beginIndex + 17);
                fieldPosition.setEndIndex(beginIndex + 19);
                break;
            }
            case 8: {
                fieldPosition.setBeginIndex(beginIndex + 20);
                fieldPosition.setEndIndex(beginIndex + 23);
            }
            case 17: {
                fieldPosition.setBeginIndex(beginIndex + 23);
                fieldPosition.setEndIndex(toAppendTo.length());
            }
        }
        return toAppendTo;
    }

    public Date parse(String source, ParsePosition parsePosition) {
        Matcher matcher = this.pattern.matcher(source.substring(parsePosition.getIndex()));
        if (!matcher.matches()) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        try {
            this.calendar.set(1, this.fourDigits.parse(matcher.group(1)).intValue());
            this.calendar.set(2, this.twoDigits.parse(matcher.group(2)).intValue() - 1);
            this.calendar.set(5, this.twoDigits.parse(matcher.group(3)).intValue());
            this.calendar.set(11, this.twoDigits.parse(matcher.group(4)).intValue());
            this.calendar.set(12, this.twoDigits.parse(matcher.group(5)).intValue());
            this.calendar.set(13, this.twoDigits.parse(matcher.group(6)).intValue());
            this.calendar.set(14, this.threeDigits.parse(matcher.group(7)).intValue());
            if (matcher.group(8).equals("Z")) {
                this.calendar.set(15, 0);
            } else if (matcher.group(8).startsWith("+")) {
                this.calendar.set(15, (this.twoDigits.parse(matcher.group(9)).intValue() * 60 + this.twoDigits.parse(matcher.group(10)).intValue()) * 60000);
            } else if (matcher.group(8).startsWith("-")) {
                this.calendar.set(15, -((this.twoDigits.parse(matcher.group(11)).intValue() * 60 + this.twoDigits.parse(matcher.group(12)).intValue()) * 60000));
            }
            this.calendar.set(16, 0);
            parsePosition.setIndex(parsePosition.getIndex() + matcher.group(0).length());
            return new Date(this.calendar.getTimeInMillis());
        }
        catch (ParseException e) {
            parsePosition.setErrorIndex(parsePosition.getIndex() + e.getErrorOffset());
            return null;
        }
    }
}

