lexer grammar Cql;
options {
  language=Java;

}
@members {
  @Override
  public void reportError(RecognitionException e) {
    throw new CqlRuntimeException("Lexer Error", e);
  }
}
@header {
	package cql;
}

T13 : '>' ;
T14 : '=' ;
T15 : '/' ;
T16 : '(' ;
T17 : ')' ;
T18 : '<' ;
T19 : '>=' ;
T20 : '<=' ;
T21 : '<>' ;

// $ANTLR src "Cql.g3" 117
QUOTE	:	'"' ;
// $ANTLR src "Cql.g3" 118
WHITESPACE	:	( ' ' | '\t' | '\r' | '\n' | '\f' ) {skip();} ;

/*
STRING is double quotes followed by a sequence of any characters except
double quotes, where backslash (\) escapes the following character
(include double quote characters). The resultant value includes all
backslash characters except those releasing a double quotes character.
This allows other systems to interpret the backslash characters. The
surrounding double quotes are also not included.
*/
// $ANTLR src "Cql.g3" 128
STRING	:
		QUOTE! ( '\\'! QUOTE | ~(QUOTE) )* QUOTE! ;

// $ANTLR src "Cql.g3" 131
AND	:	( 'A' | 'a' ) ( 'N' | 'n' ) ( 'D' | 'd' );
// $ANTLR src "Cql.g3" 132
OR	:	( 'O' | 'o' ) ( 'R' | 'r' );
// $ANTLR src "Cql.g3" 133
NOT	:	( 'N' | 'n' ) ( 'O' | 'o' ) ( 'T' | 't' );
// $ANTLR src "Cql.g3" 134
PROX	:	( 'P' | 'p' ) ( 'R' | 'r' ) ( 'O' | 'o' ) ( 'X' | 'x' );
// $ANTLR src "Cql.g3" 135
WITHIN	:	( 'W' | 'w' ) ( 'I' | 'i' ) ( 'T' | 't' )
			( 'H' | 'h' ) ( 'I' | 'i' ) ( 'N' | 'n' );


/*
IDENTIFIER is any sequence of characters excluding whitespace
characers (as defined by the current character set),
'(', ')', '=', '<', '>', and '"' (double quotes). If the final
sequence is a reserved word, that token is returned instead.
(Note that '.' is part of an identifier, and a series of digits
is also an identifier.) Reserved words are 'and', 'or', 'not',
and 'prox' (case insensitive). When a reserved word is used in
term, the term value is the word, in the exact case as
specified in a query. 
*/
// $ANTLR src "Cql.g3" 150
IDENTIFIER	:
		( ~(' ' | '\t' | '\r' | '\n' | '\f' | '(' | ')' | '=' | '<' | '>' | '/' | '"') )+ ;

