package gr.uoa.di.driver.util;

import eu.dnetlib.api.DriverService;

/**
 * A factory to create service locators.
 * 
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 *
 */
public interface ServiceLocatorFactory {

	/**
	 * Creates a dynamic service locator.
	 * 
	 * @param <S> the service type.
	 * @param serviceClass the service class.
	 * @return A service locator for services of type S.
	 */
	public <S extends DriverService> ServiceLocator<S> newServiceLocator(
			Class<S> serviceClass);
	
	/**
	 * Creates a service locator. It can be either static (if serviceUrl != null)
	 * or dynamic.
	 * 
	 * @param <S> the service type.
	 * @param serviceClass the service class.
	 * @param serviceUrl The service URL.
	 * @return A service locator for services of type S.
	 */
	public <S extends DriverService> ServiceLocator<S> newServiceLocator(
			Class<S> serviceClass, String serviceUrl);
}