package gr.uoa.di.driver.util;

import java.util.HashMap;
import java.util.Map;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;

public class ServiceNameResolverImpl implements ServiceNameResolver {
	private Map<Class<?>, String> override = new HashMap<Class<?>, String>();

	@Override
	public String getName(Object service) {
		return getName(service.getClass());
	}

	@Override
	public String getName(Class<?> serviceInterface) {
		String serviceName = null;
		
		for (Class<?> i : serviceInterface.getInterfaces()) {
			if (DriverService.class.isAssignableFrom(i)) {
				if (override.get(i) != null)
					serviceName = override.get(i);
				else
					serviceName = i.getSimpleName();
			}
		}

		return serviceName;
	}

	public Map<Class<?>, String> getOverride() {
		return override;
	}

	public void setOverride(Map<Class<?>, String> override) {
		this.override = override;
	}
}