/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.util;

import eu.dnetlib.api.DriverService;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RefreshingServiceLocator<S extends DriverService>
implements ServiceLocator<S> {
    private ServiceLocator<S> locator = null;
    private S service = null;
    private ScheduledExecutorService executor = null;
    private long period = 0L;

    @Override
    public synchronized S getService() {
        if (this.service == null) {
            this.init();
        }
        return this.service;
    }

    private void init() {
        this.service = this.locator.getService();
        this.executor.scheduleWithFixedDelay(new RefreshTask(), this.period, this.period, TimeUnit.MILLISECONDS);
    }

    public ServiceLocator<S> getLocator() {
        return this.locator;
    }

    public void setLocator(ServiceLocator<S> locator) {
        this.locator = locator;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    private class RefreshTask
    implements Runnable {
        private Logger logger = Logger.getLogger(RefreshTask.class);

        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                this.logger.debug((Object)"Refreshing service cache");
                RefreshingServiceLocator.this.service = RefreshingServiceLocator.this.locator.getService();
            }
            catch (Exception e) {
                this.logger.info((Object)"Error refreshing service", (Throwable)e);
            }
        }
    }
}

