/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.cxform;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/** This class provides a java based proxy object for accessing the CXFORM API. This API enables transformation of 
 * CRS between the ones supported by the NASA toolkit.
 *
 * @author georgeathanasopoulos
 */
public class CRSTransformProxy {

    public enum S_CRS {WGS84, GEI , J2000, GEO, MAG, GSE, GSM, SM, RTN, GSEQ, HEE, HAE, HEEQ};
    private static final Logger _logger=Logger.getLogger(CRSTransformProxy.class);;
    
   static {
      try {
        printLibLocations();
         System.load("/usr/lib/libCXFormLib.so");
         _logger.info("\n\nCXForm library has been loaded from dedicated place");
      } catch (java.lang.UnsatisfiedLinkError ex) {
         _logger.error("Error while trying to load CXFormLibrary from dedicated space at /usr/lib. Will try to load id from java.library.path folders", ex);
         try{
            System.loadLibrary("CXFormLib");
             _logger.info("\n\nCXForm library has been loaded from java.library.path");
            } catch (Exception lex) {
             _logger.error("Error while trying to load CXFormLibrary from java.library.path folders", lex);
            }
      }
   }

   public CRSTransformProxy() {
         _logger.info("CXForm library has been loaded");
   }
   
   private static void printLibLocations() {
      String property = System.getProperty("java.library.path");
      StringTokenizer parser = new StringTokenizer(property, ":");
      _logger.info("\n System library paths to be investigated for native libs include :");
      while (parser.hasMoreTokens()) {
         String location = parser.nextToken();
         File linuxlibFile = new File(location + "/libCXFormLib.so");
         File macLibFile = new File(location + "/libCXFormLib.dylib");
         if (linuxlibFile.exists() ||macLibFile.exists())
            _logger.info("Lib File ["+(linuxlibFile.exists()?"Linux version":"Mac version")+"] is available at:   ");
         else
            _logger.info("Lib file not availabe at:   ");
         _logger.info(location + "\n");
      }
      _logger.info("\n");
   }

            
   public synchronized native double[][] cxformT(String from, String to, int records, double[][] recInn);

   public synchronized native double[] cxform(String from, String to, double et, double[] vInn);

   public synchronized native double gregorianCalendar2JD(int y, int m, int d, int h, int mi, int s);

   public synchronized native long cxRound(double doub);

   public synchronized native long date2es(int yyyy, int mm, int dd, int hh, int mm2, int ss);
   
   public synchronized native double[] cart2spher(double[] vin); 

   public synchronized native double[] spher2cart(double[] vin); 
}
