/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.cxform;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CRSTransformProxy {
    private static final Logger _logger = Logger.getLogger(CRSTransformProxy.class);

    public CRSTransformProxy() {
        _logger.info((Object)"CXForm library has been loaded");
    }

    private static void printLibLocations() {
        String property = System.getProperty("java.library.path");
        StringTokenizer parser = new StringTokenizer(property, ":");
        _logger.info((Object)"\n System library paths to be investigated for native libs include :");
        while (parser.hasMoreTokens()) {
            String location = parser.nextToken();
            File linuxlibFile = new File(location + "/libCXFormLib.so");
            File macLibFile = new File(location + "/libCXFormLib.dylib");
            if (linuxlibFile.exists() || macLibFile.exists()) {
                _logger.info((Object)("Lib File [" + (linuxlibFile.exists() ? "Linux version" : "Mac version") + "] is available at:   "));
            } else {
                _logger.info((Object)"Lib file not availabe at:   ");
            }
            _logger.info((Object)(location + "\n"));
        }
        _logger.info((Object)"\n");
    }

    public synchronized native double[][] cxformT(String var1, String var2, int var3, double[][] var4);

    public synchronized native double[] cxform(String var1, String var2, double var3, double[] var5);

    public synchronized native double gregorianCalendar2JD(int var1, int var2, int var3, int var4, int var5, int var6);

    public synchronized native long cxRound(double var1);

    public synchronized native long date2es(int var1, int var2, int var3, int var4, int var5, int var6);

    public synchronized native double[] cart2spher(double[] var1);

    public synchronized native double[] spher2cart(double[] var1);

    static {
        try {
            CRSTransformProxy.printLibLocations();
            System.load("/usr/lib/libCXFormLib.so");
            _logger.info((Object)"\n\nCXForm library has been loaded from dedicated place");
        }
        catch (UnsatisfiedLinkError ex) {
            _logger.error((Object)"Error while trying to load CXFormLibrary from dedicated space at /usr/lib. Will try to load id from java.library.path folders", (Throwable)ex);
            try {
                System.loadLibrary("CXFormLib");
                _logger.info((Object)"\n\nCXForm library has been loaded from java.library.path");
            }
            catch (Exception lex) {
                _logger.error((Object)"Error while trying to load CXFormLibrary from java.library.path folders", (Throwable)lex);
            }
        }
    }

    public static enum S_CRS {
        WGS84,
        GEI,
        J2000,
        GEO,
        MAG,
        GSE,
        GSM,
        SM,
        RTN,
        GSEQ,
        HEE,
        HAE,
        HEEQ;

    }
}

