/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public abstract class AbstractAnalyzeMojo
extends AbstractMojo
implements Contextualizable {
    private Context context;
    private MavenProject project;
    private String analyzer;
    private boolean failOnWarning;
    private boolean verbose;
    private boolean ignoreNonCompile;
    private boolean outputXML;
    private boolean scriptableOutput;
    private String scriptableFlag;
    private File baseDir;
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        if (this.outputDirectory == null || !this.outputDirectory.exists()) {
            this.getLog().info((CharSequence)"Skipping project with no build directory");
            return;
        }
        boolean warning = this.checkDependencies();
        if (warning && this.failOnWarning) {
            throw new MojoExecutionException("Dependency problems found");
        }
    }

    protected ProjectDependencyAnalyzer createProjectDependencyAnalyzer() throws MojoExecutionException {
        String role = ProjectDependencyAnalyzer.ROLE;
        String roleHint = this.analyzer;
        try {
            PlexusContainer container = (PlexusContainer)this.context.get((Object)"plexus");
            return (ProjectDependencyAnalyzer)container.lookup(role, roleHint);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to instantiate ProjectDependencyAnalyzer with role " + role + " / role-hint " + roleHint, exception);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    private boolean checkDependencies() throws MojoExecutionException {
        ProjectDependencyAnalysis analysis;
        try {
            analysis = this.createProjectDependencyAnalyzer().analyze(this.project);
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MojoExecutionException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        Set usedDeclared = analysis.getUsedDeclaredArtifacts();
        Set usedUndeclared = analysis.getUsedUndeclaredArtifacts();
        HashSet unusedDeclared = analysis.getUnusedDeclaredArtifacts();
        if (this.ignoreNonCompile) {
            HashSet filteredUnusedDeclared = new HashSet(unusedDeclared);
            Iterator iter = filteredUnusedDeclared.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (artifact.getScope().equals("compile")) continue;
                iter.remove();
            }
            unusedDeclared = filteredUnusedDeclared;
        }
        if ((!this.verbose || usedDeclared.isEmpty()) && usedUndeclared.isEmpty() && unusedDeclared.isEmpty()) {
            this.getLog().info((CharSequence)"No dependency problems found");
            return false;
        }
        if (this.verbose && !usedDeclared.isEmpty()) {
            this.getLog().info((CharSequence)"Used declared dependencies found:");
            this.logArtifacts(analysis.getUsedDeclaredArtifacts(), false);
        }
        if (!usedUndeclared.isEmpty()) {
            this.getLog().warn((CharSequence)"Used undeclared dependencies found:");
            this.logArtifacts(usedUndeclared, true);
        }
        if (!unusedDeclared.isEmpty()) {
            this.getLog().warn((CharSequence)"Unused declared dependencies found:");
            this.logArtifacts(unusedDeclared, true);
        }
        if (this.outputXML) {
            this.writeDependencyXML(usedUndeclared);
        }
        if (this.scriptableOutput) {
            this.writeScriptableOutput(usedUndeclared);
        }
        return !usedUndeclared.isEmpty() || !unusedDeclared.isEmpty();
    }

    private void logArtifacts(Set artifacts, boolean warn) {
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"   None");
        } else {
            Iterator iterator = artifacts.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                artifact.isSnapshot();
                if (warn) {
                    this.getLog().warn((CharSequence)("   " + artifact));
                    continue;
                }
                this.getLog().info((CharSequence)("   " + artifact));
            }
        }
    }

    private void writeDependencyXML(Set artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Add the following to your pom to correct the missing dependencies: ");
            StringWriter out = new StringWriter();
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)out);
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                artifact.isSnapshot();
                writer.startElement("dependency");
                writer.startElement("groupId");
                writer.writeText(artifact.getGroupId());
                writer.endElement();
                writer.startElement("artifactId");
                writer.writeText(artifact.getArtifactId());
                writer.endElement();
                writer.startElement("version");
                writer.writeText(artifact.getBaseVersion());
                writer.endElement();
                if (!"compile".equals(artifact.getScope())) {
                    writer.startElement("scope");
                    writer.writeText(artifact.getScope());
                    writer.endElement();
                }
                writer.endElement();
            }
            this.getLog().info((CharSequence)("\n" + out.getBuffer()));
        }
    }

    private void writeScriptableOutput(Set artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Missing dependencies: ");
            String pomFile = this.baseDir.getAbsolutePath() + File.separatorChar + "pom.xml";
            StringBuffer buf = new StringBuffer();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                artifact.isSnapshot();
                buf.append(this.scriptableFlag + ":" + pomFile + ":" + artifact.getDependencyConflictId() + ":" + artifact.getClassifier() + ":" + artifact.getBaseVersion() + ":" + artifact.getScope() + "\n");
            }
            this.getLog().info((CharSequence)("\n" + buf));
        }
    }
}

