<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
	xmlns:utils="eu.dnetlib.miscutils.datetime.DateUtils" xmlns:tei="http://www.tei-c.org/ns/1.0"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:eagle="http://www.eagle-network.eu/eagle"
	exclude-result-prefixes="xsl tei dnet utils">

	<xsl:output indent="yes" />

	<xsl:param name="CP_ACRONYM" />
	<xsl:param name="CP_URL" />
	<xsl:param name="CP_NAME" />

	<xsl:variable name="REPO_ID" select="//dri:repositoryId" />
	<xsl:variable name="ORIG_OBJ_ID" select="//dri:objIdentifier" />

	<xsl:variable name="NOW" select="utils:now_ISO8601()" />

	<xsl:variable name="LANG" select="//lang" />
	<xsl:variable name="LOCAL_ID" select="//*[local-name()='RWO_collection']//*[local-name()='General_info']//*[local-name()='ID']" />
	<xsl:variable name="LOCAL_ID_MD5" select="dnet:md5($LOCAL_ID)" />
	<xsl:variable name="DATE_EDITED" select="//Editing_date" />
	<xsl:variable name="METADATA_EDITOR" select="//Metadata_editor" />
	<xsl:variable name="IPR_URL" select="//tei:licence/@target" />
	<xsl:variable name="IPR_STATEMENT" select="//tei:licence" />
	<xsl:variable name="TITLE" select="//Inscription/Descriptive_data/Title" />
	<xsl:variable name="DESCRIPTION" select="//Inscription/Descriptive_data/Description" />

	<xsl:template name="commonProperties">
		<recordSourceInfo>
			<xsl:attribute name="providerName">
                <xsl:value-of select="$CP_NAME" />
            </xsl:attribute>
			<xsl:attribute name="providerAcronym">
                <xsl:value-of select="$CP_ACRONYM" />
            </xsl:attribute>
			<xsl:attribute name="providerURI">
                <xsl:value-of select="$CP_URL" />
            </xsl:attribute>
			<xsl:value-of select="$LOCAL_ID" />
		</recordSourceInfo>
		<editingInfo>
			<dateEdited>
				<xsl:value-of select="$DATE_EDITED" />
			</dateEdited>
			<metadataEditor>
				<xsl:value-of select="$METADATA_EDITOR" />
			</metadataEditor>
		</editingInfo>
		<metadataIpr>
			<xsl:attribute name="url">
                <xsl:value-of select="$IPR_URL" />
            </xsl:attribute>
			<xsl:value-of select="$IPR_STATEMENT" />
		</metadataIpr>
		<title>
			<xsl:attribute name="lang">
                <xsl:value-of select="$LANG" />
            </xsl:attribute>
			<xsl:value-of select="$TITLE" />
		</title>
		<description>
			<xsl:attribute name="lang">
                <xsl:value-of select="$LANG" />
            </xsl:attribute>
			<xsl:value-of select="$DESCRIPTION" />
		</description>
	</xsl:template>

	<xsl:template match="/">
		<package>
			<!-- ARTIFACT -->
			<record>
				<header>
					<dri:objIdentifier>
						<xsl:value-of select="concat($ORIG_OBJ_ID, '_artifact')" />
					</dri:objIdentifier>
					<dri:dateOfCollection>
						<xsl:value-of select="$NOW" />
					</dri:dateOfCollection>
					<dri:repositoryId>
						<xsl:value-of select="$REPO_ID" />
					</dri:repositoryId>
				</header>
				<metadata>
					<eagleObject>
						<dnetResourceIdentifier>
							<xsl:value-of select="concat('artifact::', $CP_ACRONYM, '::', $LOCAL_ID_MD5)" />
						</dnetResourceIdentifier>
						<xsl:call-template name="commonProperties" />
						<entityType>Artifact</entityType>
						<artifact>
							<artifactType>Inscription</artifactType>
							<monumentType>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//Support/support_type" />
                                </xsl:attribute>
								<xsl:value-of select="//Support/support_type" />
							</monumentType>
							<material>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//Support/Material_support" />
                                </xsl:attribute>
								<xsl:value-of select="//Support/Material_support" />
							</material>
							<dimensions>
								<xsl:attribute name="unit">
                                    <xsl:value-of select="//Support/Dimensions/Height/unit" />
                                </xsl:attribute>
								<width>
									<xsl:value-of select="//Inscription/Descriptive_data/Support/Dimensions/Lenght/value" />
								</width>
								<height>
									<xsl:value-of select="//Inscription/Descriptive_data/Support/Dimensions/Height/value" />
								</height>
								<depth>
									<xsl:value-of select="//Inscription/Descriptive_data/Support/Dimensions/Thickness/value" />
								</depth>
							</dimensions>
							<decoration>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//decoration_of_inscription" />
                                </xsl:attribute>
								<xsl:value-of select="//decoration_of_inscription" />
							</decoration>
							<stateOfPreservation>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//Condition_of_inscription" />
                                </xsl:attribute>
								<xsl:value-of select="//Condition_of_inscription" />
							</stateOfPreservation>
							<originDating>
								<xsl:attribute name="notBefore"><xsl:value-of select="//terminus_ante_quem" /></xsl:attribute>
								<xsl:attribute name="notAfter"><xsl:value-of select="//terminus_post_quem" /></xsl:attribute>
								<xsl:attribute name="datingMethod">???</xsl:attribute>
								<xsl:attribute name="evidence">???</xsl:attribute>
								<xsl:attribute name="period"><xsl:value-of select="//Chronology//Period_name" /></xsl:attribute>
								<xsl:value-of select="//tei:origDate" />
							</originDating>
							<yearOfFinding>
								<xsl:value-of select="//Discovery/Discovery_date" />
							</yearOfFinding>
							<findingSpot>
								<romanProvinceItalicRegion>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Regio_antiqua" />
                                    </xsl:attribute>
									<xsl:value-of select="//Discovery/Regio_antiqua" />
								</romanProvinceItalicRegion>
								<ancientFindSpot>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Ancient_name" />
                                    </xsl:attribute>
									<xsl:value-of select="//Ancient_name" />
								</ancientFindSpot>
								<modernFindSpot>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Place_of_discovery" />
                                    </xsl:attribute>
									<xsl:value-of select="//Place_of_discovery" />
								</modernFindSpot>
								<modernCountry>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Discovery/Country" />
                                    </xsl:attribute>
									<xsl:value-of select="//Discovery/Country" />
								</modernCountry>
								<modernRegion>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Discovery/Region_District" />
                                    </xsl:attribute>
									<xsl:value-of select="//Discovery/Region_District" />
								</modernRegion>
<!-- 								<modernProvince> -->
<!-- 									<xsl:attribute name="uri"> -->
<!--                                         ??? -->
<!--                                     </xsl:attribute> -->
<!-- 									??? -->
<!-- 								</modernProvince> -->
							</findingSpot>
							<conservationPlace>
								<conservationCountry>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Country_of_conservation" />
                                    </xsl:attribute>
									<xsl:value-of select="//Country_of_conservation" />
								</conservationCountry>
								<conservationRegion > -->
 									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Country_of_conservation" />
                                    </xsl:attribute>
									<xsl:value-of select="//Country_of_conservation" />
 								</conservationRegion>
								<conservationCity>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Country_of_conservation" />
                                    </xsl:attribute>
									<xsl:value-of select="//Country_of_conservation" />
								</conservationCity>
								<museum>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Ownership_rights_institution" />
                                    </xsl:attribute>
									<xsl:value-of select="//Ownership_rights_institution" />
								</museum>
								<position>
									<xsl:value-of select="//External_source_catalogue_number" />
								</position>
								<inventoryNumber>
									<xsl:value-of select="//External_source_catalogue_number" />
								</inventoryNumber>
							</conservationPlace>
							<!-- ARTIFACT+INSCRIPTION -->
							<inscription>
<!-- 								<refersTrismegistosCard> -->
<!-- 									<xsl:attribute name="tm_id"> -->
<!-- 										<xsl:value-of select="//tei:publicationStmt/idno[@type='TM_id']"></xsl:value-of> -->
<!-- 									</xsl:attribute>###refersTrismegistosCard0</refersTrismegistosCard> -->
								<inscriptionType>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//Genre" />
                                    </xsl:attribute>
									<xsl:value-of select="//Genre" />
								</inscriptionType>
								<engravingTechnique>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//writing_technique" />
                                    </xsl:attribute>
									<xsl:value-of select="//writing_technique" />
								</engravingTechnique>
								<metre>
									<xsl:value-of select="//Metre" />
								</metre>
<!-- 								<fieldSize> -->
<!-- 									<xsl:attribute name="unit"> -->
<!--                                         <xsl:value-of select="//tei:layout/tei:dimensions/tei:width/@unit" /> -->
<!--                                     </xsl:attribute> -->
<!-- 									<width><xsl:value-of select="//tei:layout/tei:dimensions/tei:width" /></width> -->
<!-- 									<height><xsl:value-of select="//tei:layout/tei:dimensions/tei:height" /></height> -->
<!-- 								</fieldSize> -->
								<paleographicCharacteristics>
									<xsl:value-of select="concat('Style of writing: ', //style_of_writing, '. Style of letters: ', //style_of_letters, '. Scripture: ', //Scripture, '. Writing direction: ', //writing_direction, '. Number of signs: ', //number_of_signs, '. Numbr of lines: ', //number_of_lines)" />
								</paleographicCharacteristics>
								<letterSize unit="cm">
									<width>???</width>
									<height>???</height>
								</letterSize>
								<inscriptionAuthor><xsl:value-of select="//Author_of_inscription" /></inscriptionAuthor>
								<honorand socialStatus="socialStatus1">
									<xsl:attribute name="socialStatus" select="//Political_social_status" />
									<xsl:value-of select="//Author_of_inscription" />
								</honorand>
								<dedicator><xsl:value-of select="//AwardedBy_dedicator" /></dedicator>
								<namesMentioned><xsl:value-of select="//Other_names" /></namesMentioned>
								<relatedEvent><xsl:value-of select="//Event_of_inscritption" /></relatedEvent>
								<placesMentioned><xsl:value-of select="//Locations_mentioned" /></placesMentioned>
								<restorationInfo><xsl:value-of select="//Restoration" /></restorationInfo>
								<doubleSided><xsl:value-of select="//double_side" /></doubleSided>
								<erasures><xsl:value-of select="//erasures" /></erasures>
								<spellingErrors><xsl:value-of select="//spelling_errors_variations" /></spellingErrors>
								<xsl:for-each select="//object">
									<hasInscriptionVisualRepresentation>
										<xsl:attribute name="uri">thumbnail</xsl:attribute>
										<xsl:value-of select="concat('visual::', $CP_ACRONYM, '::', $LOCAL_ID_MD5, '::', position())" />
									</hasInscriptionVisualRepresentation>
								</xsl:for-each>
							</inscription>
						</artifact>
					</eagleObject>
				</metadata>
			</record>
			
			<!-- VISUAL REPRESENTATION -->
			<xsl:for-each select="//object">
				<record>
					<header>
						<dri:objIdentifier>
							<xsl:value-of select="concat($ORIG_OBJ_ID, '_visual', '::', position())" />
						</dri:objIdentifier>
						<dri:dateOfCollection>
							<xsl:value-of select="$NOW" />
						</dri:dateOfCollection>
						<dri:repositoryId>
							<xsl:value-of select="$REPO_ID" />
						</dri:repositoryId>
					</header>
					<metadata>
						<eagleObject>
							<dnetResourceIdentifier>
								<xsl:value-of select="concat('visual::', $CP_ACRONYM, '::', $LOCAL_ID_MD5, '::', position())" />
							</dnetResourceIdentifier>
							<xsl:call-template name="commonProperties" />
							<entityType>Visual representation</entityType>
							<visualRepresentation>
							    <representationType>Image</representationType>
							    <url>
							    	<xsl:value-of select="//object"></xsl:value-of>
							    </url>
							    <thumbnail>###to be generated by DNET workflow###</thumbnail>
							    <author>author0</author>
							    <visualRepresentationIpr uri="http://www.oxygenxml.com/">visualRepresentationIpr0</visualRepresentationIpr>
							    <creationDate>creationDate0</creationDate>
							    <quality>quality0</quality>
							    <format>format0</format>
							    <isRepresentationOf><xsl:value-of select="concat('artifact::', $CP_ACRONYM, '::', $LOCAL_ID_MD5)" /></isRepresentationOf>
							    <info3D>
							        <acquisitionTechnology>acquisitionTechnology0</acquisitionTechnology>
							        <processingInfo>processingInfo0</processingInfo>
							        <horizontalResolution>horizontalResolution0</horizontalResolution>
							        <verticalResolution>verticalResolution0</verticalResolution>
							        <modelDimensions unit="unit1">
							            <width>0</width>
							            <height>0</height>
							            <depth>0</depth>
							        </modelDimensions>
							        <modelArea>modelArea0</modelArea>
							        <modelPerimeter>modelPerimeter0</modelPerimeter>
							    </info3D>
							    <infoVideo>
							        <duration>duration0</duration>
							        <resolution>resolution0</resolution>
							        <rate>rate0</rate>
							    </infoVideo>
							</visualRepresentation>
						</eagleObject>
					</metadata>
				</record>
			</xsl:for-each>
		</package>
	</xsl:template>
</xsl:stylesheet>