package eu.dnetlib.msro.eagle.workflows.nodes.info;

import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.info.SetProviderInfoJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class SetEagleInfoJobNode extends SetProviderInfoJobNode {

	private static final String CP_ACRONYM = WorkflowsConstants.DATAPROVIDER_PREFIX + "acronym";
	private static final String CP_NAME = WorkflowsConstants.DATAPROVIDER_PREFIX + "name";
	private static final String CP_URL = WorkflowsConstants.DATAPROVIDER_PREFIX + "url";

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		String xQuery;

		xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{repoId}']//REPOSITORY_WEBPAGE/text()";
		token.getEnv().setAttribute(CP_URL, lookupLocator.getService().getResourceProfileByQuery(xQuery.replace("{repoId}", super.getProviderId())));

		xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{repoId}']//OFFICIAL_NAME/text()";
		token.getEnv().setAttribute(CP_NAME, lookupLocator.getService().getResourceProfileByQuery(xQuery.replace("{repoId}", super.getProviderId())));

		xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{repoId}']//DATASOURCE_ORIGINAL_ID/text()";
		token.getEnv().setAttribute(CP_ACRONYM, lookupLocator.getService().getResourceProfileByQuery(xQuery.replace("{repoId}", super.getProviderId())));

		return Arc.DEFAULT_ARC;
	}
}
