package eu.dnetlib.msro.eagle.workflows.nodes.transform;

import java.util.HashMap;
import java.util.Map;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * This class is intended to process records coming in MDStore compliant form (with header) 
 * and apply the xslt located at http://sourceforge.net/projects/epidoc/files/Example%20Stylesheets/
 * to the <metadata> blocks of each record.
 * @author Andrea Mannocci
 *
 */
public class ApplyEditionXsltJobNode extends SimpleJobNode {
	
	private String inputEprParam;
	private String outputEprParam;
	private String xsltClasspath;

	private MappedResultSetFactory mappedResultSetFactory;
	private final Map<String, String> xsltParams = new HashMap<String, String>();

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String inputEpr = token.getEnv().getAttribute(inputEprParam);
		if ((inputEpr == null) || inputEpr.isEmpty()) throw new MSROException("InputEprParam (" + inputEprParam + ") not found in ENV");


		for (String name : token.getFullEnv().getAttributeNames()) {
			xsltParams.put(name, token.getFullEnv().getAttribute(name));
		}
		for (String name : token.getEnv().getAttributeNames()) {
			xsltParams.put(name, token.getEnv().getAttribute(name));
		}
		
		xsltParams.putAll(parseJsonParameters(token));

		final W3CEndpointReference epr = mappedResultSetFactory.createMappedResultSet(new EPRUtils().getEpr(inputEpr), 
				new EditionXsltUnaryFunction(xsltClasspath, xsltParams));

		token.getEnv().setAttribute(outputEprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}
	
	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getXsltClasspath() {
		return xsltClasspath;
	}

	public void setXsltClasspath(String xsltClasspath) {
		this.xsltClasspath = xsltClasspath;
	}

	public MappedResultSetFactory getMappedResultSetFactory() {
		return mappedResultSetFactory;
	}

	public void setMappedResultSetFactory(
			MappedResultSetFactory mappedResultSetFactory) {
		this.mappedResultSetFactory = mappedResultSetFactory;
	}

}
