<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="findMdStore"/>
	</ARCS>
</NODE>

<NODE name="findMdStore" type="RetrieveMdStoreId">
	<DESCRIPTION>Find MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>		
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchTransformed"/>
	</ARCS>
</NODE>

<NODE name="fetchTransformed" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>		
		<PARAM required="true" type="string" name="eprParam" managedBy="system">clean_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="retrieveURL"/>
	</ARCS>
</NODE>


<NODE name="retrieveURL" type="RetrieveURLS">
	<DESCRIPTION>Retrieve URL To Download from MDStore</DESCRIPTION>
	<PARAMETERS>		
		<PARAM required="true" type="string" name="xpath" managedBy="user">//*[local-name()='visualRepresentation']//*[local-name()='url']/text()</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">clean_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">item_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="downloadRecords"/>
	</ARCS>
</NODE>


<NODE name="downloadRecords" type="DownloadFromMetadata">
	<DESCRIPTION>Transform original records in eagle format</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputeprParam" managedBy="system">item_epr</PARAM>
		<PARAM required="true" type="string" name="obejctStoreID" managedBy="system">$params.("imgstore_id")$</PARAM>
		<PARAM required="true" type="string" name="plugin" managedBy="user" function="obtainValues('listDownloadPlugins', {});"></PARAM>
		<PARAM required="false" type="string" name="protocol" managedBy="user"></PARAM>
		<PARAM required="false" type="string" name="mimeType" managedBy="user"></PARAM>		
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>