package eu.dnetlib.data.oai.store;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.common.rmi.BaseService;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;

@WebService
public interface OAIStoreService extends BaseService {

	@WebMethod
	void feed(@WebParam(name = "recordsEpr") final W3CEndpointReference recordsEpr, @WebParam(name = "mdformat") final MDFInfo mdfInfo);

	@WebMethod(operationName = "feedWithSource")
	void feed(@WebParam(name = "recordsEpr") final W3CEndpointReference recordsEpr,
			@WebParam(name = "mdformat") final MDFInfo mdfInfo,
			@WebParam(name = "recordSource") final String recordSource);

	@WebMethod
	void updateSetCounts();

	@WebMethod(operationName = "updateSetCountsForMDF")
	void updateSetCounts(@WebParam(name = "mdformat") final MDFInfo mdfInfo);

	@WebMethod
	void refreshConfiguration();

	@WebMethod
	void ensureIndexes();

	@WebMethod(operationName = "ensureIndexOnMDF")
	void ensureIndexes(@WebParam(name = "mdformat") final MDFInfo mdfInfo);
}
