/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnsureIndexesAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(EnsureIndexesAction.class);
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    private int max_threads = 1;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        try {
            String mdPrefix = (String)job.getParameters().get("ensure_mdPrefix");
            if (StringUtils.isBlank((String)mdPrefix)) {
                log.info((Object)"ensuring index on all OAI store");
                this.mongoPublisherStoreDAO.ensureIndex(this.max_threads);
            } else {
                log.info((Object)("ensuring index on " + mdPrefix + " only"));
                MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdPrefix);
                store.ensureIndices();
            }
            handler.done(job);
        }
        catch (Exception e) {
            handler.failed(job, (Throwable)e);
        }
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }

    public int getMax_threads() {
        return this.max_threads;
    }

    public void setMax_threads(int max_threads) {
        this.max_threads = max_threads;
    }
}

