/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.conf;

import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.conf.OAISetHelper;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAISetsCounter {
    private static final Log log = LogFactory.getLog(OAISetsCounter.class);
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configurationReader;
    @Resource
    private MongoSetCollection mongoSetCollection;
    @Resource
    private OAISetHelper oaiSetHelper;

    public void updateCounts(final Callable<?> callback, final Callable<?> failCallback) {
        new Thread(){

            @Override
            public void run() {
                try {
                    List metadataFormats = OAISetsCounter.this.configurationReader.getMetadataFormatInfo();
                    for (MDFInfo mdFormat : metadataFormats) {
                        OAISetsCounter.this.oaiSetHelper.updateAllCounts(mdFormat);
                    }
                    log.info((Object)"All sets count updated succesfully");
                    OAISetsCounter.this.executeCallback(callback);
                }
                catch (Exception e) {
                    log.error((Object)e);
                    OAISetsCounter.this.executeCallback(failCallback);
                }
            }
        }.start();
    }

    public void updateCounts(final MDFInfo mdf, final Callable<?> callback, final Callable<?> failCallback) {
        new Thread(){

            @Override
            public void run() {
                try {
                    OAISetsCounter.this.oaiSetHelper.updateAllCounts(mdf);
                    log.info((Object)("All sets count updated succesfully for metadata format " + mdf));
                    OAISetsCounter.this.executeCallback(callback);
                }
                catch (Exception e) {
                    log.error((Object)e);
                    OAISetsCounter.this.executeCallback(failCallback);
                }
            }
        }.start();
    }

    protected void executeCallback(Callable<?> callback) {
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                log.error((Object)"Error executing callback", (Throwable)e);
            }
        }
    }

    public OAIConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public OAISetHelper getOaiSetCounterHelper() {
        return this.oaiSetHelper;
    }

    public void setOaiSetCounterHelper(OAISetHelper oaiSetHelper) {
        this.oaiSetHelper = oaiSetHelper;
    }
}

