/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.google.common.collect.Sets;
import com.mongodb.DBObject;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.oai.store.mongo.MetadataExtractor;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class RecordInfoGenerator {
    @Resource
    private MetadataExtractor metadataExtractor;

    public RecordInfo transformDBObject(DBObject object, boolean includeBody) {
        String id = (String)object.get("objIdentifier");
        id = StringEscapeUtils.escapeXml((String)id);
        boolean deleted = (Boolean)object.get("deleted");
        RecordInfo record = new RecordInfo();
        record.setIdentifier(id);
        record.setInternalId(object.get("_id").toString());
        record.setDatestamp((Date)object.get("datestamp"));
        record.setDeleted(deleted);
        List sets = (List)object.get("set");
        if (sets != null) {
            record.setSetspecs((Set)Sets.newHashSet((Iterable)sets));
        }
        if (includeBody && !deleted) {
            String body = (String)object.get("body");
            SAXReader reader = new SAXReader();
            try {
                Document doc = reader.read((Reader)new StringReader(body));
                record.setMetadata(this.metadataExtractor.evaluate(doc));
            }
            catch (DocumentException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
        return record;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }
}

